/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.detector.rules;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.camunda.community.migration.detector.rules.CodeMigrationReport;

public class CodeMigrationReportPrinter {
    private static final Template REPORT_TEMPLATE;

    public static void print(Writer writer, CodeMigrationReport report) {
        REPORT_TEMPLATE.execute((Object)CodeMigrationReportPrinter.transform(report), writer);
    }

    private static MustacheContext transform(CodeMigrationReport report) {
        ArrayList<MustacheContext.RootContext> classes = new ArrayList<MustacheContext.RootContext>();
        report.classes().forEach((className, reportForClass) -> {
            ArrayList<MustacheContext.RootContext.ClassContext> rules = new ArrayList<MustacheContext.RootContext.ClassContext>();
            reportForClass.rules().forEach((rule, reportsForRule) -> {
                ArrayList<MustacheContext.RootContext.ClassContext.RuleContext> violations = new ArrayList<MustacheContext.RootContext.ClassContext.RuleContext>();
                reportsForRule.forEach(reportForRule -> violations.add(new MustacheContext.RootContext.ClassContext.RuleContext(reportForRule.violation())));
                rules.add(new MustacheContext.RootContext.ClassContext((String)rule, (List<MustacheContext.RootContext.ClassContext.RuleContext>)violations));
            });
            classes.add(new MustacheContext.RootContext((String)className, (List<MustacheContext.RootContext.ClassContext>)rules));
        });
        return new MustacheContext(classes);
    }

    static {
        try (InputStream in = CodeMigrationReportPrinter.class.getClassLoader().getResourceAsStream("migrationReport.mustache");){
            REPORT_TEMPLATE = Mustache.compiler().compile(new String(in.readAllBytes()));
        }
        catch (IOException e) {
            throw new RuntimeException("Error while loading report printer template", e);
        }
    }

    record MustacheContext(List<RootContext> classes) {

        record RootContext(String className, List<ClassContext> rules) {

            record ClassContext(String rule, List<RuleContext> violations) {

                record RuleContext(String violation) {
                }
            }
        }
    }
}

