/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.processInstance.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.camunda.community.migration.processInstance.client.Camunda7Client;
import org.camunda.community.migration.processInstance.dto.Camunda7ProcessDefinitionData;
import org.camunda.community.migration.processInstance.dto.Camunda7ProcessInstanceData;
import org.camunda.community.migration.processInstance.dto.client.ActivityInstanceDto;
import org.camunda.community.migration.processInstance.dto.client.ProcessDefinitionDto;
import org.camunda.community.migration.processInstance.dto.client.ProcessInstanceDto;
import org.camunda.community.migration.processInstance.service.ProcessInstanceMigrationHintRule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Camunda7Service {
    private final Camunda7Client camunda7Client;
    private final Set<ProcessInstanceMigrationHintRule> processInstanceMigrationHintRules;

    @Autowired
    public Camunda7Service(Camunda7Client camunda7Client, Set<ProcessInstanceMigrationHintRule> processInstanceMigrationHintRules) {
        this.camunda7Client = camunda7Client;
        this.processInstanceMigrationHintRules = processInstanceMigrationHintRules;
    }

    private List<String> getMigrationHints(Camunda7ProcessInstanceData processData) {
        return this.processInstanceMigrationHintRules.stream().map(rule -> rule.createHint((ProcessInstanceMigrationHintRule.ProcessInstanceMigrationHintRuleContext)processData)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public Camunda7ProcessInstanceData getProcessData(String camunda7ProcessInstanceId) {
        Camunda7ProcessInstanceData processData = new Camunda7ProcessInstanceData();
        processData.setProcessInstanceId(camunda7ProcessInstanceId);
        ProcessInstanceDto processInstance = this.camunda7Client.getProcessInstance(camunda7ProcessInstanceId);
        ProcessDefinitionDto processDefinition = this.camunda7Client.getProcessDefinition(processInstance.getDefinitionId());
        processData.setProcessDefinitionKey(processDefinition.getKey());
        HashMap<String, Camunda7ProcessInstanceData.ProcessVariableData> variables = new HashMap<String, Camunda7ProcessInstanceData.ProcessVariableData>();
        NullNode businessKey = processInstance.getBusinessKey() == null ? NullNode.getInstance() : TextNode.valueOf((String)processInstance.getBusinessKey());
        variables.put("businessKey", Camunda7ProcessInstanceData.ProcessVariableData.of((JsonNode)businessKey, (String)camunda7ProcessInstanceId));
        this.camunda7Client.getVariableInstances(camunda7ProcessInstanceId).forEach(variable -> variables.put(variable.getName(), Camunda7ProcessInstanceData.ProcessVariableData.of((JsonNode)variable.getValue(), (String)variable.getExecutionId())));
        processData.setProcessVariables(variables);
        ActivityInstanceDto activities = this.camunda7Client.getActivityInstances(camunda7ProcessInstanceId);
        processData.setActivities(this.extractFromTree(activities));
        processData.setMigrationHints(this.getMigrationHints(processData));
        processData.setBusinessKey(processInstance.getBusinessKey());
        processData.setJobData(this.getJobs(camunda7ProcessInstanceId));
        return processData;
    }

    private List<Camunda7ProcessInstanceData.JobData> getJobs(String camunda7ProcessInstanceId) {
        return this.camunda7Client.getJobs(camunda7ProcessInstanceId).stream().map(dto -> {
            Camunda7ProcessInstanceData.JobData data = new Camunda7ProcessInstanceData.JobData();
            data.setJobDefinitionId(dto.getJobDefinitionId());
            data.setId(dto.getId());
            return data;
        }).collect(Collectors.toList());
    }

    private List<Camunda7ProcessInstanceData.ActivityData> extractFromTree(ActivityInstanceDto activityInstanceDto) {
        Camunda7ProcessInstanceData.ActivityData data = new Camunda7ProcessInstanceData.ActivityData();
        data.setId(activityInstanceDto.getActivityId());
        data.setType(activityInstanceDto.getActivityType());
        data.setLeaf(Boolean.valueOf(true));
        ArrayList<Camunda7ProcessInstanceData.ActivityData> result = new ArrayList<Camunda7ProcessInstanceData.ActivityData>();
        if (!data.getType().equals("processDefinition")) {
            result.add(data);
        }
        if (activityInstanceDto.getChildActivityInstances() != null && !activityInstanceDto.getChildActivityInstances().isEmpty()) {
            data.setLeaf(Boolean.valueOf(false));
            result.addAll(activityInstanceDto.getChildActivityInstances().stream().flatMap(dto -> this.extractFromTree(dto).stream()).collect(Collectors.toList()));
        }
        if (activityInstanceDto.getChildTransitionInstances() != null && !activityInstanceDto.getChildTransitionInstances().isEmpty()) {
            data.setLeaf(Boolean.valueOf(false));
            result.addAll(activityInstanceDto.getChildTransitionInstances().stream().map(transitionInstanceDto -> {
                Camunda7ProcessInstanceData.ActivityData transitionData = new Camunda7ProcessInstanceData.ActivityData();
                transitionData.setId(transitionInstanceDto.getActivityId());
                transitionData.setType(transitionInstanceDto.getActivityType());
                transitionData.setLeaf(Boolean.valueOf(true));
                return transitionData;
            }).collect(Collectors.toList()));
        }
        return result;
    }

    public void suspendProcessDefinition(String processDefinitionId, boolean suspended) {
        this.camunda7Client.suspendProcessDefinitionById(processDefinitionId, suspended);
    }

    public void cancelProcessInstance(String camunda7ProcessInstanceId, Long camunda8ProcessInstanceKey) {
        this.camunda7Client.setVariable(camunda7ProcessInstanceId, "camunda8ProcessInstanceKey", (Object)camunda8ProcessInstanceKey);
        this.camunda7Client.cancelProcessInstance(camunda7ProcessInstanceId);
    }

    public List<ProcessInstanceDto> getProcessInstancesByProcessDefinitionId(String processDefinitionId) {
        return this.camunda7Client.getProcessInstancesByProcessDefinition(processDefinitionId);
    }

    public Camunda7ProcessDefinitionData getLatestProcessDefinition(String bpmnProcessId) {
        Camunda7ProcessDefinitionData data = new Camunda7ProcessDefinitionData();
        ProcessDefinitionDto processDefinitionByKey = this.camunda7Client.getLatestProcessDefinitionByKey(bpmnProcessId);
        data.setProcessDefinition(processDefinitionByKey);
        if (data.getProcessDefinition() != null) {
            data.setJobDefinitions(this.camunda7Client.getJobDefinitions(Camunda7Client.Camunda7JobType.ASYNC_CONTINUATION, Camunda7Client.Camunda7JobConfiguration.ASYNC_BEFORE, data.getProcessDefinition().getId()));
        }
        return data;
    }

    public void suspendJobDefinitions(Set<String> selectedJobDefinitions) {
        selectedJobDefinitions.forEach(jobId -> this.camunda7Client.suspendJobDefinition(jobId, true));
    }

    public List<Camunda7ProcessInstanceData> getProcessInstancesByProcessDefinitionIdAndExclusiveActivityIds(String camunda7ProcessDefinitionId, Collection<String> activityIds) {
        return this.camunda7Client.getProcessInstancesByProcessDefinitionAndActivityIds(camunda7ProcessDefinitionId, activityIds).stream().map(pi -> this.getProcessData(pi.getId())).filter(pi -> pi.getActivities().stream().filter(Camunda7ProcessInstanceData.ActivityData::getLeaf).map(Camunda7ProcessInstanceData.ActivityData::getId).allMatch(activityIds::contains)).collect(Collectors.toList());
    }

    public void continueJobDefinitions(Set<String> selectedJobDefinitions) {
        selectedJobDefinitions.forEach(jobId -> this.camunda7Client.suspendJobDefinition(jobId, false));
    }
}

