/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.processInstance.service;

import io.camunda.operate.CamundaOperateClient;
import io.camunda.operate.exception.OperateException;
import io.camunda.operate.model.ProcessDefinition;
import io.camunda.operate.search.Filter;
import io.camunda.operate.search.ProcessDefinitionFilter;
import io.camunda.operate.search.SearchQuery;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.command.CreateProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import io.camunda.zeebe.client.api.response.PublishMessageResponse;
import io.camunda.zeebe.model.bpmn.Bpmn;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.camunda.community.migration.processInstance.dto.Camunda8ProcessDefinitionData;
import org.camunda.community.migration.processInstance.variables.ProcessInstanceMigrationVariables;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Camunda8Service {
    private final ZeebeClient zeebeClient;
    private final CamundaOperateClient operateClient;

    @Autowired
    public Camunda8Service(ZeebeClient zeebeClient, CamundaOperateClient operateClient) {
        this.zeebeClient = zeebeClient;
        this.operateClient = operateClient;
    }

    public PublishMessageResponse startProcessInstanceMigration(String bpmnProcessId) {
        ProcessInstanceMigrationVariables variables = new ProcessInstanceMigrationVariables();
        variables.setBpmnProcessId(bpmnProcessId);
        return (PublishMessageResponse)this.zeebeClient.newPublishMessageCommand().messageName("migration.camunda:start").correlationKey(bpmnProcessId).timeToLive(Duration.ofSeconds(3L)).variables((Object)variables).send().join();
    }

    public ProcessInstanceEvent startProcessInstanceMigrationRouter(String bpmnProcessId) {
        ProcessInstanceMigrationVariables variables = new ProcessInstanceMigrationVariables();
        variables.setBpmnProcessId(bpmnProcessId);
        return (ProcessInstanceEvent)this.zeebeClient.newCreateInstanceCommand().bpmnProcessId("RoutedProcessInstanceMigrationProcess").latestVersion().variables((Object)variables).send().join();
    }

    public ProcessInstanceEvent startMigratedProcessInstance(String bpmnProcessId, List<String> activityIds, Map<String, Object> variables) {
        CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 command = this.zeebeClient.newCreateInstanceCommand().bpmnProcessId(bpmnProcessId).latestVersion().variables(variables);
        activityIds.forEach(arg_0 -> ((CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3)command).startBeforeElement(arg_0));
        return (ProcessInstanceEvent)command.send().join();
    }

    public void completeTask(long jobKey, ProcessInstanceMigrationVariables result) {
        this.zeebeClient.newCompleteCommand(jobKey).variables((Object)result).send().join();
    }

    public void selectProcessInstances(long jobKey, List<String> processInstances) {
        this.zeebeClient.newCompleteCommand(jobKey).variables(Collections.singletonMap("camunda7ProcessInstanceIds", processInstances)).send().join();
    }

    public List<ProcessDefinition> queryProcessDefinitions(String bpmnProcessId) {
        ProcessDefinitionFilter filter = new ProcessDefinitionFilter();
        filter.setBpmnProcessId(bpmnProcessId);
        SearchQuery query = new SearchQuery();
        query.setFilter((Filter)filter);
        try {
            return Optional.ofNullable(this.operateClient.searchProcessDefinitions(query)).orElseGet(ArrayList::new);
        }
        catch (OperateException e) {
            throw new RuntimeException(e);
        }
    }

    public Camunda8ProcessDefinitionData getProcessDefinitionData(Long processDefinitionKey) {
        Camunda8ProcessDefinitionData data = new Camunda8ProcessDefinitionData();
        try {
            data.setProcessDefinition(this.operateClient.getProcessDefinition(processDefinitionKey));
            data.setBpmnModelInstance(Bpmn.readModelFromStream((InputStream)new ByteArrayInputStream(this.operateClient.getProcessDefinitionXml(processDefinitionKey).getBytes())));
            return data;
        }
        catch (OperateException e) {
            throw new RuntimeException(e);
        }
    }

    public void cancelProcessInstance(Long processInstanceKey) {
        this.zeebeClient.newCancelInstanceCommand(processInstanceKey.longValue()).send().join();
    }
}

