/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.processInstance;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.camunda.community.migration.processInstance.dto.rest.ProcessInstanceMigrationStartRequestDto;
import org.camunda.community.migration.processInstance.dto.rest.UserTaskDto;
import org.camunda.community.migration.processInstance.dto.task.UserTask;
import org.camunda.community.migration.processInstance.properties.Camunda7ClientProperties;
import org.camunda.community.migration.processInstance.properties.OperateClientProperties;
import org.camunda.community.migration.processInstance.service.Camunda8Service;
import org.camunda.community.migration.processInstance.service.MigrationTaskService;
import org.camunda.community.migration.processInstance.service.TaskMappingService;
import org.camunda.community.migration.processInstance.variables.ProcessInstanceMigrationVariables;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/migration"})
public class ProcessInstanceMigrationController {
    private final MigrationTaskService selectionService;
    private final Camunda8Service camunda8Service;
    private final TaskMappingService taskMappingService;
    private final OperateClientProperties operateClientProperties;
    private final Camunda7ClientProperties camunda7ClientProperties;

    @Autowired
    public ProcessInstanceMigrationController(MigrationTaskService selectionService, Camunda8Service camunda8Service, TaskMappingService taskMappingService, OperateClientProperties operateClientProperties, Camunda7ClientProperties camunda7ClientProperties) {
        this.selectionService = selectionService;
        this.camunda8Service = camunda8Service;
        this.taskMappingService = taskMappingService;
        this.operateClientProperties = operateClientProperties;
        this.camunda7ClientProperties = camunda7ClientProperties;
    }

    @PostMapping(value={"/start"})
    public ResponseEntity<?> start(@RequestBody ProcessInstanceMigrationStartRequestDto dto) {
        if (dto.getMigrationType() == null) {
            return ResponseEntity.badRequest().body((Object)"Please provide a migration type: 'simple','router'");
        }
        if (dto.getMigrationType().equals("simple")) {
            this.camunda8Service.startProcessInstanceMigration(dto.getBpmnProcessId());
            return ResponseEntity.ok().build();
        }
        if (dto.getMigrationType().equals("router")) {
            this.camunda8Service.startProcessInstanceMigrationRouter(dto.getBpmnProcessId());
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.badRequest().body((Object)("Invalid migration type '" + dto.getMigrationType() + "'.Please provide a migration type: 'simple','router'"));
    }

    @GetMapping(value={"/tasks"})
    public List<UserTaskDto> tasks(@RequestParam(value="includeCompleted", defaultValue="false") boolean includeCompleted) {
        return this.selectionService.getTasks(includeCompleted).stream().map(arg_0 -> this.fromTask(arg_0)).collect(Collectors.toList());
    }

    @GetMapping(value={"/tasks/{id}"})
    public UserTaskDto task(@PathVariable(value="id") Long id) {
        return this.fromTask(this.selectionService.getTask(id.longValue()));
    }

    @PutMapping(value={"/tasks/{id}"})
    public UserTaskDto complete(@PathVariable(value="id") Long id, @RequestBody ProcessInstanceMigrationVariables body) {
        return this.fromTask(this.selectionService.complete(id.longValue(), body));
    }

    @GetMapping(value={"/links"})
    public Map<String, Object> links() {
        HashMap<String, Object> links = new HashMap<String, Object>();
        links.put("C8", this.operateClientProperties.getBaseUrl());
        links.put("C7", this.camunda7ClientProperties.getBaseUrl());
        return links;
    }

    private UserTaskDto fromTask(UserTask task) {
        UserTaskDto userTaskDto = new UserTaskDto();
        userTaskDto.setProcessInstanceKey(task.getProcessInstanceKey());
        userTaskDto.setName(task.getName());
        userTaskDto.setKey(task.getKey());
        userTaskDto.setState(task.getState());
        userTaskDto.setType(task.getType());
        userTaskDto.setData(this.taskMappingService.crateDto(task.getType(), task.getData()));
        return userTaskDto;
    }
}

