/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.processInstance.configuration;

import io.camunda.operate.CamundaOperateClient;
import io.camunda.operate.auth.AuthInterface;
import io.camunda.operate.auth.SaasAuthentication;
import io.camunda.operate.auth.SelfManagedAuthentication;
import io.camunda.operate.auth.SimpleAuthentication;
import io.camunda.operate.exception.OperateException;
import org.camunda.community.migration.processInstance.properties.OperateClientProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OperateClientConfiguration {
    private final OperateClientProperties properties;

    @Autowired
    public OperateClientConfiguration(OperateClientProperties properties) {
        this.properties = properties;
    }

    @Bean
    public AuthInterface operateAuthentication() {
        if (this.properties.getAuthentication().getSaas() != null) {
            return new SaasAuthentication(this.properties.getAuthentication().getSaas().getClientId(), this.properties.getAuthentication().getSaas().getClientSecret());
        }
        if (this.properties.getAuthentication().getSelfManaged() != null) {
            return new SelfManagedAuthentication().clientId(this.properties.getAuthentication().getSelfManaged().getClientId()).clientSecret(this.properties.getAuthentication().getSelfManaged().getClientSecret()).keycloakUrl(this.properties.getAuthentication().getSelfManaged().getKeycloakUrl()).keycloakRealm(this.properties.getAuthentication().getSelfManaged().getKeycloakRealm());
        }
        if (this.properties.getAuthentication().getSimple() != null) {
            return new SimpleAuthentication(this.properties.getAuthentication().getSimple().getUsername(), this.properties.getAuthentication().getSimple().getPassword(), this.properties.getBaseUrl());
        }
        throw new IllegalStateException("No authentication configured for Operate client");
    }

    @Bean
    public CamundaOperateClient operateClient(AuthInterface authentication) throws OperateException {
        return new CamundaOperateClient.Builder().operateUrl(this.properties.getBaseUrl()).authentication(authentication).build();
    }
}

