/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.processInstance.service;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.camunda.community.migration.processInstance.dto.task.UserTask;
import org.camunda.community.migration.processInstance.service.Camunda8Service;
import org.camunda.community.migration.processInstance.variables.ProcessInstanceMigrationVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MigrationTaskService {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationTaskService.class);
    private final Camunda8Service camunda8Service;
    private final Map<Long, UserTask> taskList = new HashMap();
    private final Map<Long, LocalDateTime> timeouts = new HashMap();

    @Autowired
    public MigrationTaskService(Camunda8Service camunda8Service) {
        this.camunda8Service = camunda8Service;
    }

    public List<UserTask> getTasks(boolean includeCompleted) {
        HashSet removed = new HashSet();
        this.timeouts.forEach((key, timeout) -> {
            if (timeout.isBefore(LocalDateTime.now())) {
                LOG.info("Task with key '{}' timed out", key);
                this.taskList.remove(key);
                removed.add(key);
            }
        });
        removed.forEach(this.timeouts::remove);
        return this.taskList.values().stream().filter(task -> includeCompleted || task.getState().equals((Object)UserTask.TaskState.CREATED)).collect(Collectors.toList());
    }

    public UserTask getTask(long jobKey) {
        return (UserTask)this.taskList.get(jobKey);
    }

    public void addTask(UserTask task) {
        UserTask fromList;
        this.timeouts.put(task.getKey(), LocalDateTime.now().plusMinutes(1L));
        if (task.getState().equals((Object)UserTask.TaskState.CREATED) && (fromList = (UserTask)this.taskList.get(task.getKey())) != null && fromList.getState().equals((Object)UserTask.TaskState.COMPLETED)) {
            return;
        }
        LOG.info("Added task with key '{}'", (Object)task.getKey());
        this.taskList.put(task.getKey(), task);
    }

    public UserTask complete(long jobKey, ProcessInstanceMigrationVariables result) {
        UserTask fromList = (UserTask)this.taskList.get(jobKey);
        if (fromList != null) {
            this.camunda8Service.completeTask(jobKey, result);
            fromList = fromList.state(UserTask.TaskState.COMPLETED);
            this.taskList.put(jobKey, fromList);
            return fromList;
        }
        throw new IllegalStateException("Task with key '" + jobKey + "' does not exist");
    }
}

