/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.processInstance.client;

import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.camunda.community.migration.processInstance.client.Camunda7Client;
import org.camunda.community.migration.processInstance.dto.client.ActivityInstanceDto;
import org.camunda.community.migration.processInstance.dto.client.JobDefinitionDto;
import org.camunda.community.migration.processInstance.dto.client.ProcessDefinitionDto;
import org.camunda.community.migration.processInstance.dto.client.ProcessInstanceDto;
import org.camunda.community.migration.processInstance.dto.client.VariableInstanceDto;
import org.camunda.community.migration.processInstance.dto.client.VersionDto;
import org.camunda.community.migration.processInstance.dto.rest.JobDto;
import org.camunda.community.migration.processInstance.properties.Camunda7ClientProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

public class Camunda7RestClient
implements Camunda7Client {
    private static final Logger LOG = LoggerFactory.getLogger(Camunda7Client.class);
    private static final String BY_ID = "/{id}";
    private static final String SUSPENDED = "/suspended";
    private static final String PROCESS_DEFINITION = "/process-definition";
    private static final String PROCESS_INSTANCE = "/process-instance";
    private static final String VARIABLE_INSTANCE = "/variable-instance";
    private static final String JOB_DEFINITION = "/job-definition";
    private static final String JOB = "/job";
    private static final String PROCESS_DEFINITION_BY_ID = "/process-definition/{id}";
    private static final String PROCESS_DEFINITION_SUSPENDED = "/process-definition/{id}/suspended";
    private static final String PROCESS_INSTANCE_BY_ID = "/process-instance/{id}";
    private static final String PROCESS_INSTANCE_VARIABLES = "/process-instance/{id}/variables";
    private static final String PROCESS_INSTANCE_VARIABLE = "/process-instance/{id}/variables/{varName}";
    private static final String PROCESS_INSTANCE_ACTIVITY_INSTANCES = "/process-instance/{id}/activity-instances";
    private static final String VERSION = "/version";
    private static final String HISTORY = "/history";
    private static final String HISTORIC_ACTIVITY_INSTANCE = "/history/activity-instance";
    private static final String JOB_DEFINITION_BY_ID = "/job-definition/{id}";
    private static final String JOB_DEFINITION_SUSPENDED = "/job-definition/{id}/suspended";
    private final RestTemplate restTemplate;
    private final Camunda7ClientProperties properties;

    public Camunda7RestClient(RestTemplate restTemplate, Camunda7ClientProperties properties) {
        this.restTemplate = restTemplate;
        this.properties = properties;
    }

    @PostConstruct
    public void testConnection() {
        if (this.properties.getCheckOnInit().booleanValue()) {
            try {
                VersionDto version = this.getVersion();
                LOG.info("Connected to Camunda 7 version {}", (Object)version.getVersion());
            }
            catch (Exception e) {
                throw new RuntimeException("Could not establish a connection to Camunda 7", e);
            }
        }
    }

    private String buildQuery(Set<String> keys) {
        return "?" + keys.stream().map(key -> key + "={" + key + "}").collect(Collectors.joining("&"));
    }

    public List<JobDefinitionDto> getJobDefinitions(Camunda7Client.Camunda7JobType jobType, Camunda7Client.Camunda7JobConfiguration jobConfiguration, String processDefinitionId) {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("jobType", jobType.getName());
        variables.put("jobConfiguration", jobConfiguration.getName());
        variables.put("processDefinitionId", processDefinitionId);
        return (List)this.restTemplate.getForObject(JOB_DEFINITION + this.buildQuery(variables.keySet()), JobDefinitionDto.JobDefinitionQueryResultDto.class, variables);
    }

    public void suspendJobDefinition(String jobDefinitionId, boolean suspended) {
        HashMap<String, Boolean> body = new HashMap<String, Boolean>();
        body.put("suspended", suspended);
        body.put("includeJobs", true);
        this.restTemplate.put(JOB_DEFINITION_SUSPENDED, body, Collections.singletonMap("id", jobDefinitionId));
    }

    public VersionDto getVersion() {
        return (VersionDto)this.restTemplate.getForObject(VERSION, VersionDto.class, new Object[0]);
    }

    public void suspendProcessDefinitionById(String processDefinitionId, boolean suspended) {
        HashMap<String, Boolean> body = new HashMap<String, Boolean>();
        body.put("suspended", suspended);
        body.put("includeProcessInstances", true);
        this.restTemplate.put(PROCESS_DEFINITION_SUSPENDED, body, Collections.singletonMap("id", processDefinitionId));
    }

    public ProcessInstanceDto getProcessInstance(String processInstanceId) {
        return (ProcessInstanceDto)this.restTemplate.getForObject(PROCESS_INSTANCE_BY_ID, ProcessInstanceDto.class, Collections.singletonMap("id", processInstanceId));
    }

    public ProcessDefinitionDto getProcessDefinition(String processDefinitionId) {
        return (ProcessDefinitionDto)this.restTemplate.getForObject(PROCESS_DEFINITION_BY_ID, ProcessDefinitionDto.class, Collections.singletonMap("id", processDefinitionId));
    }

    public ActivityInstanceDto getActivityInstances(String processInstanceId) {
        return (ActivityInstanceDto)this.restTemplate.getForObject(PROCESS_INSTANCE_ACTIVITY_INSTANCES, ActivityInstanceDto.class, Collections.singletonMap("id", processInstanceId));
    }

    public void cancelProcessInstance(String processInstanceId) {
        this.restTemplate.delete(PROCESS_INSTANCE_BY_ID, Collections.singletonMap("id", processInstanceId));
    }

    public void setVariable(String processInstanceId, String variableName, Object variableValue) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("value", variableValue);
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("id", processInstanceId);
        uriVariables.put("varName", variableName);
        this.restTemplate.put(PROCESS_INSTANCE_VARIABLE, body, uriVariables);
    }

    public List<ProcessInstanceDto> getProcessInstancesByProcessDefinition(String processDefinitionId) {
        Map<String, String> parameters = Collections.singletonMap("processDefinitionId", processDefinitionId);
        return (List)this.restTemplate.getForObject(PROCESS_INSTANCE + this.buildQuery(parameters.keySet()), ProcessInstanceDto.ProcessInstanceQueryResultDto.class, parameters);
    }

    public List<ProcessInstanceDto> getProcessInstancesByProcessDefinitionAndActivityIds(String processDefinitionId, Collection<String> activityIds) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("processDefinitionId", processDefinitionId);
        parameters.put("activityIdIn", String.join((CharSequence)",", activityIds));
        return (List)this.restTemplate.getForObject(PROCESS_INSTANCE + this.buildQuery(parameters.keySet()), ProcessInstanceDto.ProcessInstanceQueryResultDto.class, parameters);
    }

    public ProcessDefinitionDto getLatestProcessDefinitionByKey(String processDefinitionKey) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("latestVersion", Boolean.TRUE.toString());
        parameters.put("key", processDefinitionKey);
        List result = (List)this.restTemplate.getForObject(PROCESS_DEFINITION + this.buildQuery(parameters.keySet()), ProcessDefinitionDto.ProcessDefinitionQueryResultDto.class, parameters);
        return result == null || result.isEmpty() ? null : (ProcessDefinitionDto)result.get(0);
    }

    public List<VariableInstanceDto> getVariableInstances(String processInstanceId) {
        Map<String, String> parameters = Collections.singletonMap("processInstanceIdIn", processInstanceId);
        return (List)this.restTemplate.getForObject(VARIABLE_INSTANCE + this.buildQuery(parameters.keySet()), VariableInstanceDto.VariableInstanceQueryResultDto.class, parameters);
    }

    public List<JobDto> getJobs(String camunda7ProcessInstanceId) {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("processInstanceId", camunda7ProcessInstanceId);
        return (List)this.restTemplate.getForObject(JOB + this.buildQuery(variables.keySet()), JobDto.JobQueryResultDto.class, variables);
    }
}

