/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.processInstance;

import io.camunda.operate.model.ProcessDefinition;
import io.camunda.operate.search.Filter;
import io.camunda.operate.search.ProcessDefinitionFilter;
import io.camunda.operate.search.SearchQuery;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import io.camunda.zeebe.spring.client.annotation.JobWorker;
import io.camunda.zeebe.spring.client.annotation.VariablesAsType;
import io.camunda.zeebe.spring.client.exception.ZeebeBpmnError;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.camunda.community.migration.processInstance.dto.Camunda7ProcessDefinitionData;
import org.camunda.community.migration.processInstance.dto.Camunda7ProcessInstanceData;
import org.camunda.community.migration.processInstance.dto.client.JobDefinitionDto;
import org.camunda.community.migration.processInstance.dto.task.UserTask;
import org.camunda.community.migration.processInstance.service.Camunda7Service;
import org.camunda.community.migration.processInstance.service.Camunda8Service;
import org.camunda.community.migration.processInstance.service.MigrationTaskService;
import org.camunda.community.migration.processInstance.service.ProcessDefinitionMigrationHintService;
import org.camunda.community.migration.processInstance.service.TaskMappingService;
import org.camunda.community.migration.processInstance.variables.ProcessInstanceMigrationVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ZeebeJobClient {
    private static final Logger LOG = LoggerFactory.getLogger(ZeebeJobClient.class);
    private final Camunda7Service camunda7Service;
    private final MigrationTaskService migrationTaskService;
    private final Camunda8Service camunda8Service;
    private final ProcessDefinitionMigrationHintService processDefinitionMigrationHintService;
    private final TaskMappingService taskMappingService;

    public ZeebeJobClient(Camunda7Service camunda7Service, MigrationTaskService migrationTaskService, Camunda8Service camunda8Service, ProcessDefinitionMigrationHintService processDefinitionMigrationHintService, TaskMappingService taskMappingService) {
        this.camunda7Service = camunda7Service;
        this.migrationTaskService = migrationTaskService;
        this.camunda8Service = camunda8Service;
        this.processDefinitionMigrationHintService = processDefinitionMigrationHintService;
        this.taskMappingService = taskMappingService;
    }

    @JobWorker(type="camunda7:process-definition:suspend")
    public void suspendProcessDefinition(@VariablesAsType ProcessInstanceMigrationVariables variables) {
        LOG.info("Suspending process definition '{}'", (Object)variables.getCamunda7ProcessDefinitionId());
        this.camunda7Service.suspendProcessDefinition(variables.getCamunda7ProcessDefinitionId(), true);
    }

    @JobWorker(type="camunda7:job-definition:suspend")
    public void suspendJob(@VariablesAsType ProcessInstanceMigrationVariables variables) {
        Map selectedJobDefinitions = variables.getSelectedJobDefinitions();
        LOG.info("Suspending job definitions {}", (Object)selectedJobDefinitions);
        this.camunda7Service.suspendJobDefinitions(selectedJobDefinitions.keySet());
    }

    @JobWorker(type="camunda7:job-definition:continue")
    public void continueJob(@VariablesAsType ProcessInstanceMigrationVariables variables) {
        Map selectedJobDefinitions = variables.getSelectedJobDefinitions();
        LOG.info("Continuing job definitions {}", (Object)selectedJobDefinitions);
        this.camunda7Service.continueJobDefinitions(selectedJobDefinitions.keySet());
    }

    @JobWorker(type="camunda7:process-instance:query:routable")
    public ProcessInstanceMigrationVariables queryRoutableInstances(@VariablesAsType ProcessInstanceMigrationVariables variables) {
        variables.setCamunda7ProcessInstanceIds(this.camunda7Service.getProcessInstancesByProcessDefinitionIdAndExclusiveActivityIds(variables.getCamunda7ProcessDefinitionId(), variables.getSelectedJobDefinitions().values()).stream().map(Camunda7ProcessInstanceData::getProcessInstanceId).collect(Collectors.toList()));
        LOG.info("Found process instances to migrate: {}", (Object)variables.getCamunda7ProcessInstanceIds());
        return variables;
    }

    @JobWorker(type="camunda7:process-instance:get")
    public ProcessInstanceMigrationVariables extractProcessData(@VariablesAsType ProcessInstanceMigrationVariables variables) {
        LOG.info("Extracting process data from '{}'", (Object)variables.getCamunda7ProcessInstanceId());
        Camunda7ProcessInstanceData processData = this.camunda7Service.getProcessData(variables.getCamunda7ProcessInstanceId());
        LOG.info("Returning activity ids '{}'", (Object)processData.getActivities());
        variables.setActivityIds(processData.getActivities().stream().map(Camunda7ProcessInstanceData.ActivityData::getId).collect(Collectors.toList()));
        variables.setVariables(processData.getProcessVariables().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Camunda7ProcessInstanceData.ProcessVariableData)e.getValue()).getValue())));
        LOG.info("Returning variables '{}'", (Object)processData.getProcessVariables());
        return variables;
    }

    @JobWorker(type="camunda8:process-definition:check")
    public ProcessInstanceMigrationVariables checkProcessDefinition(@VariablesAsType ProcessInstanceMigrationVariables variables) {
        LOG.info("Checking if process definition '{}' already exists", (Object)variables.getBpmnProcessId());
        SearchQuery query = new SearchQuery();
        ProcessDefinitionFilter filter = new ProcessDefinitionFilter();
        filter.setBpmnProcessId(variables.getBpmnProcessId());
        query.setFilter((Filter)filter);
        Optional<ProcessDefinition> processDefinition = this.camunda8Service.queryProcessDefinitions(variables.getBpmnProcessId()).stream().max(Comparator.comparingLong(ProcessDefinition::getVersion));
        boolean alreadyConverted = processDefinition.isPresent();
        processDefinition.ifPresent(pd -> variables.setConversionHints(this.processDefinitionMigrationHintService.getMigrationHints(this.camunda8Service.getProcessDefinitionData(pd.getKey()))));
        LOG.info("Found {} process definition", (Object)(processDefinition.isPresent() ? "a" : "no"));
        variables.setAlreadyConverted(Boolean.valueOf(alreadyConverted));
        return variables;
    }

    @JobWorker(type="camunda8:process-instance:create")
    public ProcessInstanceMigrationVariables startCamunda8ProcessInstance(@VariablesAsType ProcessInstanceMigrationVariables variables) {
        HashMap<String, String> processVariables = new HashMap<String, String>(variables.getVariables());
        processVariables.put("camunda7ProcessInstanceId", variables.getCamunda7ProcessInstanceId());
        LOG.info("Starting process instance with corresponding c7 instance '{}' at {}", (Object)variables.getCamunda7ProcessInstanceId(), (Object)variables.getActivityIds());
        ProcessInstanceEvent processInstanceEvent = this.camunda8Service.startMigratedProcessInstance(variables.getBpmnProcessId(), variables.getActivityIds(), processVariables);
        LOG.info("Started process instance with key '{}'", (Object)processInstanceEvent.getProcessInstanceKey());
        variables.setCamunda8ProcessInstanceKey(Long.valueOf(processInstanceEvent.getProcessInstanceKey()));
        return variables;
    }

    @JobWorker(type="camunda7:process-definition:continue")
    public void continueProcessDefinition(@VariablesAsType ProcessInstanceMigrationVariables variables) {
        LOG.info("Continuing process definition '{}'", (Object)variables.getBpmnProcessId());
        this.camunda7Service.suspendProcessDefinition(variables.getCamunda7ProcessDefinitionId(), false);
    }

    @JobWorker(type="camunda7:process-instance:cancel")
    public void cancelProcessInstance(@VariablesAsType ProcessInstanceMigrationVariables variables) {
        LOG.info("Canceling process instance '{}'", (Object)variables.getCamunda7ProcessInstanceId());
        try {
            this.camunda7Service.cancelProcessInstance(variables.getCamunda7ProcessInstanceId(), variables.getCamunda8ProcessInstanceKey());
        }
        catch (Exception e) {
            throw new ZeebeBpmnError("camunda7:process-instance:cancel:error", "Error while cancelling process instance " + variables.getCamunda7ProcessInstanceId());
        }
    }

    @JobWorker(type="camunda8:process-instance:cancel")
    public void cancelCamunda8ProcessInstance(@VariablesAsType ProcessInstanceMigrationVariables variables) {
        this.camunda8Service.cancelProcessInstance(variables.getCamunda8ProcessInstanceKey());
    }

    @JobWorker(type="camunda7:process-definition:get")
    public ProcessInstanceMigrationVariables extractVersionInformation(@VariablesAsType ProcessInstanceMigrationVariables variables) {
        Camunda7ProcessDefinitionData data = this.camunda7Service.getLatestProcessDefinition(variables.getBpmnProcessId());
        variables.setCamunda7ProcessDefinitionId(data.getProcessDefinition().getId());
        variables.setCamunda7JobDefinitions(data.getJobDefinitions().stream().collect(Collectors.toMap(JobDefinitionDto::getId, JobDefinitionDto::getActivityId)));
        return variables;
    }

    @JobWorker(type="io.camunda.zeebe:userTask", timeout=1000L, autoComplete=false, requestTimeout=1000L)
    public void userTask(ActivatedJob job, @VariablesAsType ProcessInstanceMigrationVariables variables) {
        String formKey = (String)job.getCustomHeaders().get("io.camunda.zeebe:formKey");
        this.taskMappingService.createUserTaskData(formKey, variables).ifPresent(data -> this.migrationTaskService.addTask(new UserTask(Long.valueOf(job.getKey()), this.taskMappingService.getTaskName(formKey), Long.valueOf(job.getProcessInstanceKey()), formKey, data, UserTask.TaskState.CREATED)));
    }
}

