/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.processInstance.service;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.camunda.community.migration.processInstance.dto.rest.ConversionAndDeploymentCreationTaskDataDto;
import org.camunda.community.migration.processInstance.dto.rest.JobDefinitionSelectionTaskDataDto;
import org.camunda.community.migration.processInstance.dto.rest.ProcessInstanceSelectionTaskDataDto;
import org.camunda.community.migration.processInstance.dto.rest.RouteExecutionCancellationTaskDataDto;
import org.camunda.community.migration.processInstance.dto.rest.UserTaskDto;
import org.camunda.community.migration.processInstance.dto.task.ConversionAndDeploymentCreationTaskData;
import org.camunda.community.migration.processInstance.dto.task.JobDefinitionSelectionTaskData;
import org.camunda.community.migration.processInstance.dto.task.ProcessInstanceSelectionTaskData;
import org.camunda.community.migration.processInstance.dto.task.RouteExecutionCancellationTaskData;
import org.camunda.community.migration.processInstance.dto.task.UserTask;
import org.camunda.community.migration.processInstance.service.Camunda7Service;
import org.camunda.community.migration.processInstance.variables.ProcessInstanceMigrationVariables;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskMappingService {
    private static final Map<String, BiFunction<ProcessInstanceMigrationVariables, Camunda7Service, UserTask.UserTaskData>> TO_USER_TASK_MAPPING = new HashMap();
    private static final Map<String, Function<UserTask.UserTaskData, UserTaskDto.UserTaskDataDto>> TO_DTO_MAPPING = new HashMap();
    private static final Map<String, String> TASK_NAME_MAPPING = new HashMap();
    private final Camunda7Service camunda7Service;

    @Autowired
    public TaskMappingService(Camunda7Service camunda7Service) {
        this.camunda7Service = camunda7Service;
    }

    public String getTaskName(String type) {
        return (String)TASK_NAME_MAPPING.get(type);
    }

    public Optional<UserTask.UserTaskData> createUserTaskData(String type, ProcessInstanceMigrationVariables variables) {
        return Optional.ofNullable((BiFunction)TO_USER_TASK_MAPPING.get(type)).map(mapper -> (UserTask.UserTaskData)mapper.apply(variables, this.camunda7Service));
    }

    public UserTaskDto.UserTaskDataDto crateDto(String type, UserTask.UserTaskData data) {
        return Optional.ofNullable((Function)TO_DTO_MAPPING.get(type)).map(mapper -> (UserTaskDto.UserTaskDataDto)mapper.apply(data)).orElseThrow(() -> new NullPointerException("No registered Mapper for type '" + type + "' present"));
    }

    static {
        TASK_NAME_MAPPING.put("select-process-instances", "Select Process Instances");
        TASK_NAME_MAPPING.put("create-and-deploy-conversion", "Create and deploy Conversion");
        TASK_NAME_MAPPING.put("select-job-definition", "Select job definition");
        TASK_NAME_MAPPING.put("cancel-route-execution", "Cancel route execution");
        TO_USER_TASK_MAPPING.put("select-process-instances", (variables, service) -> new ProcessInstanceSelectionTaskData(variables.getBpmnProcessId(), variables.getCamunda7ProcessDefinitionId(), service.getProcessInstancesByProcessDefinitionId(variables.getCamunda7ProcessDefinitionId()).stream().map(dto -> service.getProcessData(dto.getId())).collect(Collectors.toList())));
        TO_USER_TASK_MAPPING.put("create-and-deploy-conversion", (variables, service) -> new ConversionAndDeploymentCreationTaskData(variables.getBpmnProcessId()));
        TO_USER_TASK_MAPPING.put("select-job-definition", (variables, service) -> new JobDefinitionSelectionTaskData(variables.getCamunda7ProcessDefinitionId(), variables.getCamunda7JobDefinitions()));
        TO_USER_TASK_MAPPING.put("cancel-route-execution", (variables, service) -> new RouteExecutionCancellationTaskData(variables.getCamunda7ProcessDefinitionId(), variables.getCamunda7JobDefinitions()));
        TO_DTO_MAPPING.put("select-process-instances", data -> {
            ProcessInstanceSelectionTaskDataDto dto = new ProcessInstanceSelectionTaskDataDto();
            dto.setBpmnProcessId(((ProcessInstanceSelectionTaskData)data.as(ProcessInstanceSelectionTaskData.class)).getBpmnProcessId());
            dto.setAvailableProcessInstances(((ProcessInstanceSelectionTaskData)data.as(ProcessInstanceSelectionTaskData.class)).getAvailableProcessInstances().stream().map(pi -> {
                ProcessInstanceSelectionTaskDataDto.ProcessInstanceDataDto instanceDataDto = new ProcessInstanceSelectionTaskDataDto.ProcessInstanceDataDto();
                instanceDataDto.setId(pi.getProcessInstanceId());
                instanceDataDto.setBusinessKey(pi.getBusinessKey());
                instanceDataDto.setMigrationHints(pi.getMigrationHints());
                return instanceDataDto;
            }).collect(Collectors.toList()));
            return dto;
        });
        TO_DTO_MAPPING.put("create-and-deploy-conversion", data -> {
            ConversionAndDeploymentCreationTaskDataDto dto = new ConversionAndDeploymentCreationTaskDataDto();
            dto.setBpmnProcessId(((ConversionAndDeploymentCreationTaskData)data.as(ConversionAndDeploymentCreationTaskData.class)).getBpmnProcessId());
            return dto;
        });
        TO_DTO_MAPPING.put("select-job-definition", data -> {
            JobDefinitionSelectionTaskDataDto dto = new JobDefinitionSelectionTaskDataDto();
            dto.setCamunda7ProcessDefinitionId(((JobDefinitionSelectionTaskData)data.as(JobDefinitionSelectionTaskData.class)).getCamunda7ProcessDefinitionId());
            dto.setCamunda7JobDefinitions(((JobDefinitionSelectionTaskData)data.as(JobDefinitionSelectionTaskData.class)).getCamunda7JobDefinitions());
            return dto;
        });
        TO_DTO_MAPPING.put("cancel-route-execution", data -> {
            RouteExecutionCancellationTaskDataDto dto = new RouteExecutionCancellationTaskDataDto();
            dto.setCamunda7ProcessDefinitionId(((RouteExecutionCancellationTaskData)data.as(RouteExecutionCancellationTaskData.class)).getCamunda7ProcessDefinitionId());
            dto.setCamunda7JobDefinitions(((RouteExecutionCancellationTaskData)data.as(RouteExecutionCancellationTaskData.class)).getCamunda7JobDefinitions());
            return dto;
        });
    }
}

