/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.example;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.spring.client.EnableZeebeClient;
import io.camunda.zeebe.spring.client.annotation.Deployment;
import java.util.Collections;
import org.camunda.community.migration.adapter.EnableCamunda7Adapter;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;

@SpringBootApplication
@EnableZeebeClient
@EnableCamunda7Adapter
@Deployment(resources={"classpath:*.bpmn"})
public class Application {
    public static void main(String ... args) {
        ConfigurableApplicationContext context = SpringApplication.run(Application.class, (String[])args);
        ZeebeClient engineClient = (ZeebeClient)context.getBean(ZeebeClient.class);
        engineClient.newCreateInstanceCommand().bpmnProcessId("sample-process-solution-process").latestVersion().variables(Collections.singletonMap("x", 7)).send().join();
    }
}

