/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.mockito.delegate;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineServices;
import org.camunda.bpm.engine.delegate.BaseDelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateCaseExecution;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.ProcessEngineServicesAware;
import org.camunda.bpm.engine.task.IdentityLink;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.UserTask;
import org.camunda.community.mockito.delegate.DelegateCaseExecutionFake;
import org.camunda.community.mockito.delegate.DelegateExecutionFake;
import org.camunda.community.mockito.delegate.DelegateFake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegateTaskFake
extends DelegateFake<DelegateTaskFake>
implements DelegateTask,
Serializable {
    private static Predicate<IdentityLink> isUserLink = link -> link.getUserId() != null;
    private static Predicate<IdentityLink> isGroupLink = link -> link.getGroupId() != null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String id;
    private final Set<IdentityLink> candidates = new LinkedHashSet<IdentityLink>();
    private String name;
    private String description;
    private int priority;
    private String processInstanceId;
    private String executionId;
    private String processDefinitionId;
    private String caseInstanceId;
    private String caseExecutionId;
    private String caseDefinitionId;
    private Date createTime;
    private String taskDefinitionKey;
    private String eventName;
    private String owner;
    private String assignee;
    private Date dueDate;
    private Date followUpDate;
    private String deleteReason;
    private String tenantId;
    private boolean completed;
    private ProcessEngine processEngine;
    private ProcessEngineServices processEngineServices;
    private DelegateExecution delegateExecution;
    private DelegateCaseExecution delegateCaseExecution;

    public static Set<String> candidateUserIds(DelegateTask task) {
        return DelegateTaskFake.userIds(task, "candidate");
    }

    public static Set<String> candidateGroupIds(DelegateTask task) {
        return DelegateTaskFake.groupIds(task, "candidate");
    }

    public static Set<String> userIds(DelegateTask task) {
        return DelegateTaskFake.userIds(task, null);
    }

    public static Set<String> userIds(DelegateTask task, String type) {
        return DelegateTaskFake.linkIds(task, IdentityLink::getUserId, type);
    }

    public static Set<String> groupIds(DelegateTask task) {
        return DelegateTaskFake.groupIds(task, null);
    }

    public static Set<String> groupIds(DelegateTask task, String type) {
        return DelegateTaskFake.linkIds(task, IdentityLink::getGroupId, type);
    }

    private static Set<String> linkIds(DelegateTask task, Function<IdentityLink, String> extract, String type) {
        return Optional.ofNullable(task.getCandidates()).orElseGet(HashSet::new).stream().filter(link -> type == null || type.equals(link.getType())).map(extract).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public DelegateTaskFake() {
        this(null);
    }

    public DelegateTaskFake(String id) {
        this.withId(id);
    }

    public String getId() {
        return this.id;
    }

    public DelegateTaskFake withId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DelegateTaskFake withName(String name) {
        this.setName(name);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DelegateTaskFake withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public DelegateTaskFake withPriority(int priority) {
        this.setPriority(priority);
        return this;
    }

    public String getProcessInstanceId() {
        return this.valueFromCaseOrProcessExecution(DelegateExecution::getProcessInstanceId, c -> null, this.processInstanceId);
    }

    public DelegateTaskFake withProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    public String getProcessDefinitionId() {
        return Optional.ofNullable(this.delegateExecution).map(DelegateExecution::getProcessDefinitionId).orElse(this.processDefinitionId);
    }

    public DelegateTaskFake withProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    public String getCaseInstanceId() {
        return Optional.ofNullable(this.delegateCaseExecution).map(DelegateCaseExecution::getCaseInstanceId).orElse(this.caseInstanceId);
    }

    public DelegateTaskFake withCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    public String getCaseExecutionId() {
        return Optional.ofNullable(this.delegateCaseExecution).map(DelegateCaseExecution::getId).orElse(this.caseExecutionId);
    }

    public DelegateTaskFake withCaseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
        return this;
    }

    public String getCaseDefinitionId() {
        return Optional.ofNullable(this.delegateCaseExecution).map(DelegateCaseExecution::getCaseDefinitionId).orElse(this.caseDefinitionId);
    }

    public DelegateTaskFake withCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
        return this;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public DelegateTaskFake withCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    public DelegateTaskFake withTaskDefinitionKey(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
        return this;
    }

    public DelegateExecution getExecution() {
        return this.delegateExecution;
    }

    public DelegateExecutionFake getExecutionFake() {
        return (DelegateExecutionFake)this.getExecution();
    }

    public String getExecutionId() {
        return Optional.ofNullable(this.delegateExecution).map(BaseDelegateExecution::getId).orElse(this.executionId);
    }

    public DelegateTaskFake withExecutionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    public DelegateTaskFake withExecution(DelegateExecution execution) {
        this.delegateExecution = execution;
        return this;
    }

    public DelegateCaseExecution getCaseExecution() {
        return this.delegateCaseExecution;
    }

    public DelegateCaseExecutionFake getCaseExecutionFake() {
        return (DelegateCaseExecutionFake)this.getCaseExecution();
    }

    public DelegateTaskFake withCaseExecution(DelegateCaseExecution caseExecution) {
        this.delegateCaseExecution = caseExecution;
        return this;
    }

    public String getEventName() {
        return this.eventName;
    }

    public DelegateTaskFake withEventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    private IdentityLink identityLink(final String userId, final String groupId, final String type) {
        return new IdentityLink(){

            public String getId() {
                return UUID.randomUUID().toString();
            }

            public String getType() {
                return type;
            }

            public String getUserId() {
                return userId;
            }

            public String getGroupId() {
                return groupId;
            }

            public String getTaskId() {
                return this.getId();
            }

            public String getProcessDefId() {
                return DelegateTaskFake.this.getProcessDefinitionId();
            }

            public String getTenantId() {
                return DelegateTaskFake.this.valueFromCaseOrProcessExecution(DelegateExecution::getTenantId, DelegateCaseExecution::getTenantId, DelegateTaskFake.this.tenantId);
            }

            public String toString() {
                return new StringJoiner(", ", IdentityLink.class.getSimpleName() + "[", "]").add("userId=" + this.getUserId()).add("groupId=" + this.getGroupId()).add("type=" + this.getType()).toString();
            }
        };
    }

    public void addCandidateUser(String userId) {
        this.addUserIdentityLink(userId, "candidate");
    }

    public void addCandidateUsers(Collection<String> candidateUsers) {
        candidateUsers.forEach(this::addCandidateUser);
    }

    public void addCandidateGroup(String groupId) {
        this.addGroupIdentityLink(groupId, "candidate");
    }

    public void addCandidateGroups(Collection<String> candidateGroups) {
        candidateGroups.forEach(this::addCandidateGroup);
    }

    public void addUserIdentityLink(String userId, String type) {
        this.candidates.add(this.identityLink(userId, null, type));
    }

    public void addGroupIdentityLink(String groupId, String type) {
        this.candidates.add(this.identityLink(null, groupId, type));
    }

    public void deleteCandidateUser(String userId) {
        this.deleteUserIdentityLink(userId, "candidate");
    }

    public void deleteCandidateGroup(String groupId) {
        this.deleteGroupIdentityLink(groupId, "candidate");
    }

    public void deleteUserIdentityLink(String userId, String type) {
        this.candidates.removeIf(identityLink -> type.equals(identityLink.getType()) && identityLink.getUserId() != null && userId.equals(identityLink.getUserId()));
    }

    public void deleteGroupIdentityLink(String groupId, String type) {
        this.candidates.removeIf(identityLink -> type.equals(identityLink.getType()) && identityLink.getGroupId() != null && groupId.equals(identityLink.getGroupId()));
    }

    public Set<IdentityLink> getCandidates() {
        return this.candidates;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public DelegateTaskFake withAssignee(String assignee) {
        this.setAssignee(assignee);
        return this;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public String getDeleteReason() {
        return this.deleteReason;
    }

    public DelegateTaskFake withDeleteReason(String deleteReason) {
        this.deleteReason = deleteReason;
        return this;
    }

    public BpmnModelInstance getBpmnModelInstance() {
        throw new UnsupportedOperationException("not implemented");
    }

    public UserTask getBpmnModelElementInstance() {
        throw new UnsupportedOperationException("not implemented");
    }

    public String getTenantId() {
        return this.valueFromCaseOrProcessExecution(DelegateExecution::getTenantId, DelegateCaseExecution::getTenantId, this.tenantId);
    }

    public Date getFollowUpDate() {
        return this.followUpDate;
    }

    public void setFollowUpDate(Date followUpDate) {
        this.followUpDate = followUpDate;
    }

    public DelegateTaskFake withFollowUpDate(Date followUpDate) {
        this.setFollowUpDate(followUpDate);
        return this;
    }

    public DelegateTaskFake withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public void complete() {
        this.log.info("task completed!");
        this.completed = true;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public ProcessEngineServices getProcessEngineServices() {
        return this.valueFromCaseOrProcessExecution(ProcessEngineServicesAware::getProcessEngineServices, ProcessEngineServicesAware::getProcessEngineServices, this.processEngineServicesAwareFake.getProcessEngineServices());
    }

    @Override
    public ProcessEngine getProcessEngine() {
        return this.valueFromCaseOrProcessExecution(ProcessEngineServicesAware::getProcessEngine, ProcessEngineServicesAware::getProcessEngine, this.processEngineServicesAwareFake.getProcessEngine());
    }

    private <T> T valueFromCaseOrProcessExecution(Function<DelegateExecution, T> fromProcess, Function<DelegateCaseExecution, T> fromCase, T fromTask) {
        return Optional.ofNullable(this.delegateExecution).map(fromProcess).orElse(Optional.ofNullable(this.delegateCaseExecution).map(fromCase).orElse(fromTask));
    }

    public String toString() {
        return "DelegateTaskFake{id='" + this.id + "', candidates=" + this.candidates + ", name='" + this.name + "', description='" + this.description + "', priority=" + this.priority + ", processInstanceId='" + this.processInstanceId + "', executionId='" + this.executionId + "', processDefinitionId='" + this.processDefinitionId + "', caseInstanceId='" + this.caseInstanceId + "', caseExecutionId='" + this.caseExecutionId + "', caseDefinitionId='" + this.caseDefinitionId + "', createTime=" + this.createTime + ", taskDefinitionKey='" + this.taskDefinitionKey + "', eventName='" + this.eventName + "', owner='" + this.owner + "', assignee='" + this.assignee + "', dueDate=" + this.dueDate + ", deleteReason='" + this.deleteReason + "', tenantId='" + this.tenantId + "', completed=" + this.completed + ", processEngine='" + this.getProcessEngine() + "', processEngineServices=" + this.getProcessEngineServices() + ", delegateExecution=" + this.delegateExecution + ", delegateCaseExecution=" + this.delegateCaseExecution + "}";
    }
}

