/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.mockito.function;

import java.util.Arrays;
import java.util.function.BiFunction;
import org.camunda.bpm.engine.ProcessEngineServices;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;

public class DeployProcess
implements BiFunction<String, BpmnModelInstance, Deployment> {
    private final RepositoryService repositoryService;

    public DeployProcess(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public DeployProcess(ProcessEngineServices processEngineServices) {
        this(processEngineServices.getRepositoryService());
    }

    public Deployment apply(BpmnModelInstanceResource ... modelInstanceResources) {
        DeploymentBuilder builder = this.repositoryService.createDeployment();
        Arrays.stream(modelInstanceResources).forEach(r -> r.addToDeployment(builder));
        return builder.deploy();
    }

    @Override
    public Deployment apply(final String processId, final BpmnModelInstance instance) {
        return this.apply(new BpmnModelInstanceResource(){

            @Override
            public String getResourceName() {
                return processId + ".bpmn";
            }

            @Override
            public BpmnModelInstance getModelInstance() {
                return instance;
            }
        });
    }

    public static interface BpmnModelInstanceResource {
        public String getResourceName();

        public BpmnModelInstance getModelInstance();

        default public DeploymentBuilder addToDeployment(DeploymentBuilder builder) {
            builder.addModelInstance(this.getResourceName(), this.getModelInstance());
            return builder;
        }
    }
}

