/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.mockito.function;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.camunda.community.mockito.DelegateExpressions;
import org.camunda.community.mockito.function.ReadXmlDocumentFromResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParseDelegateExpressions
implements Function<URL, List<Pair<ExpressionType, String>>> {
    static final String PATTERN_DELEGATE_EXPRESSION = "[#$]\\{([^}]+)}";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ReadXmlDocumentFromResource readXmlDocumentFromResource = new ReadXmlDocumentFromResource();

    public static String extractDelegateExpressionName(String delegateExpression) {
        return StringUtils.isNotBlank((CharSequence)delegateExpression) ? delegateExpression.replaceAll(PATTERN_DELEGATE_EXPRESSION, "$1") : null;
    }

    @Override
    public List<Pair<ExpressionType, String>> apply(URL bpmnResource) {
        final Element root = new ReadXmlDocumentFromResource().apply(bpmnResource).getDocumentElement();
        return new ArrayList<Pair<ExpressionType, String>>(){
            {
                for (ExpressionType type : ExpressionType.values()) {
                    NodeList nodes = root.getElementsByTagNameNS("*", type.element);
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        NamedNodeMap attributes = nodes.item(i).getAttributes();
                        Node delegateExpression = Optional.ofNullable(attributes.getNamedItem("delegateExpression")).orElse(attributes.getNamedItem("camunda:delegateExpression"));
                        if (delegateExpression == null) continue;
                        this.add(Pair.of((Object)((Object)type), (Object)ParseDelegateExpressions.extractDelegateExpressionName(delegateExpression.getTextContent())));
                    }
                }
            }
        };
    }

    public static enum ExpressionType {
        EXECUTION_LISTENER("executionListener"){

            @Override
            public void registerMock(String name) {
                DelegateExpressions.registerExecutionListenerMock(name);
            }
        }
        ,
        TASK_LISTENER("taskListener"){

            @Override
            public void registerMock(String name) {
                DelegateExpressions.registerTaskListenerMock(name);
            }
        }
        ,
        JAVA_DELEGATE("serviceTask"){

            @Override
            public void registerMock(String name) {
                DelegateExpressions.registerJavaDelegateMock(name);
            }
        };

        private final String element;

        private ExpressionType(String element) {
            this.element = element;
        }

        public abstract void registerMock(String var1);
    }
}

