/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.mockito.verify;

import org.camunda.community.mockito.verify.MockitoVerification;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public abstract class AbstractMockitoVerification<M, P>
implements MockitoVerification<P> {
    protected final M mock;
    protected final ArgumentCaptor<P> argumentCaptor;

    public AbstractMockitoVerification(M mock, Class<P> parameterType) {
        this.mock = mock;
        this.argumentCaptor = ArgumentCaptor.forClass(parameterType);
    }

    @Override
    public final ArgumentCaptor<P> executed() {
        return this.executed(Mockito.times((int)1));
    }

    @Override
    public final ArgumentCaptor<P> executed(VerificationMode verificationMode) {
        try {
            this.doVerify(verificationMode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.argumentCaptor;
    }

    @Override
    public ArgumentCaptor<P> executedNever() {
        return this.executed(Mockito.never());
    }

    protected abstract void doVerify(VerificationMode var1) throws Exception;
}

