/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.mockito.service;

import io.holunda.camunda.bpm.data.factory.VariableFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class RuntimeServiceStubBuilder {
    private final RuntimeService runtimeService;
    private final VariableMap variables;
    private final VariableMap localVariables;
    private final List<VariableFactory<?>> factories = new ArrayList();

    public RuntimeServiceStubBuilder(RuntimeService runtimeService, VariableMap variables, VariableMap localVariables) {
        this.runtimeService = runtimeService;
        this.variables = variables;
        this.localVariables = localVariables;
    }

    public RuntimeServiceStubBuilder(RuntimeService runtimeService) {
        this(runtimeService, Variables.createVariables(), Variables.createVariables());
    }

    public <T> RuntimeServiceStubBuilder define(VariableFactory<T> variableFactory) {
        this.factories.add(variableFactory);
        return this;
    }

    public <T> RuntimeServiceStubBuilder defineAndInitialize(VariableFactory<T> variableFactory, T initialValue) {
        this.define(variableFactory);
        variableFactory.on(this.variables).set(initialValue);
        return this;
    }

    public <T> RuntimeServiceStubBuilder defineAndInitializeLocal(VariableFactory<T> variableFactory, T initialValue) {
        this.define(variableFactory);
        variableFactory.on(this.localVariables).set(initialValue);
        return this;
    }

    public RuntimeService build() {
        this.factories.forEach(factory -> {
            ((RuntimeService)Mockito.doAnswer(invocation -> factory.from(this.variables).get()).when((Object)this.runtimeService)).getVariable(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)factory.getName()));
            ((RuntimeService)Mockito.doAnswer(invocation -> this.variables.put((Object)factory.getName(), invocation.getArguments()[2])).when((Object)this.runtimeService)).setVariable(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)factory.getName()), ArgumentMatchers.any());
            ((RuntimeService)Mockito.doAnswer(invocation -> this.variables).when((Object)this.runtimeService)).getVariables(ArgumentMatchers.anyString());
            ((RuntimeService)Mockito.doAnswer(invocation -> {
                List requestedVariableNames = (List)invocation.getArguments()[1];
                return this.variables.entrySet().stream().filter(variable -> requestedVariableNames.contains(variable.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
            }).when((Object)this.runtimeService)).getVariables(ArgumentMatchers.anyString(), (Collection)ArgumentMatchers.anyList());
            ((RuntimeService)Mockito.doAnswer(invocation -> factory.from(this.localVariables).get()).when((Object)this.runtimeService)).getVariableLocal(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)factory.getName()));
            ((RuntimeService)Mockito.doAnswer(invocation -> this.localVariables.put((Object)factory.getName(), invocation.getArguments()[2])).when((Object)this.runtimeService)).setVariableLocal(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)factory.getName()), ArgumentMatchers.any());
            ((RuntimeService)Mockito.doAnswer(invocation -> this.localVariables).when((Object)this.runtimeService)).getVariablesLocal(ArgumentMatchers.anyString());
            ((RuntimeService)Mockito.doAnswer(invocation -> {
                List requestedVariableNames = (List)invocation.getArguments()[1];
                return this.localVariables.entrySet().stream().filter(variable -> requestedVariableNames.contains(variable.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
            }).when((Object)this.runtimeService)).getVariablesLocal(ArgumentMatchers.anyString(), (Collection)ArgumentMatchers.anyList());
        });
        return this.runtimeService;
    }
}

