/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.mockito.service;

import io.holunda.camunda.bpm.data.factory.VariableFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TaskServiceStubBuilder {
    private final TaskService taskService;
    private final VariableMap variables;
    private final VariableMap localVariables;
    private final List<VariableFactory<?>> factories = new ArrayList();

    public TaskServiceStubBuilder(TaskService taskService, VariableMap variables, VariableMap localVariables) {
        this.taskService = taskService;
        this.variables = variables;
        this.localVariables = localVariables;
    }

    public TaskServiceStubBuilder(TaskService taskService) {
        this(taskService, Variables.createVariables(), Variables.createVariables());
    }

    public <T> TaskServiceStubBuilder define(VariableFactory<T> variableFactory) {
        this.factories.add(variableFactory);
        return this;
    }

    public <T> TaskServiceStubBuilder defineAndInitialize(VariableFactory<T> variableFactory, T initialValue) {
        this.define(variableFactory);
        variableFactory.on(this.variables).set(initialValue);
        return this;
    }

    public <T> TaskServiceStubBuilder defineAndInitializeLocal(VariableFactory<T> variableFactory, T initialValue) {
        this.define(variableFactory);
        variableFactory.on(this.localVariables).set(initialValue);
        return this;
    }

    public TaskService build() {
        this.factories.forEach(factory -> {
            ((TaskService)Mockito.doAnswer(invocation -> factory.from(this.variables).get()).when((Object)this.taskService)).getVariable(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)factory.getName()));
            ((TaskService)Mockito.doAnswer(invocation -> this.variables.put((Object)factory.getName(), invocation.getArguments()[2])).when((Object)this.taskService)).setVariable(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)factory.getName()), ArgumentMatchers.any());
            ((TaskService)Mockito.doAnswer(invocation -> this.variables).when((Object)this.taskService)).getVariables(ArgumentMatchers.anyString());
            ((TaskService)Mockito.doAnswer(invocation -> {
                List requestedVariableNames = (List)invocation.getArguments()[1];
                return this.variables.entrySet().stream().filter(variable -> requestedVariableNames.contains(variable.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
            }).when((Object)this.taskService)).getVariables(ArgumentMatchers.anyString(), (Collection)ArgumentMatchers.anyList());
            ((TaskService)Mockito.doAnswer(invocation -> factory.from(this.localVariables).get()).when((Object)this.taskService)).getVariableLocal(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)factory.getName()));
            ((TaskService)Mockito.doAnswer(invocation -> this.localVariables.put((Object)factory.getName(), invocation.getArguments()[2])).when((Object)this.taskService)).setVariableLocal(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)factory.getName()), ArgumentMatchers.any());
            ((TaskService)Mockito.doAnswer(invocation -> this.localVariables).when((Object)this.taskService)).getVariablesLocal(ArgumentMatchers.anyString());
            ((TaskService)Mockito.doAnswer(invocation -> {
                List requestedVariableNames = (List)invocation.getArguments()[1];
                return this.localVariables.entrySet().stream().filter(variable -> requestedVariableNames.contains(variable.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
            }).when((Object)this.taskService)).getVariablesLocal(ArgumentMatchers.anyString(), (Collection)ArgumentMatchers.anyList());
        });
        return this.taskService;
    }
}

