/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.mockito.service;

import io.holunda.camunda.bpm.data.factory.VariableFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class CaseServiceStubBuilder {
    private final CaseService caseService;
    private final VariableMap variables;
    private final VariableMap localVariables;
    private final List<VariableFactory<?>> factories = new ArrayList();

    public CaseServiceStubBuilder(CaseService caseService, VariableMap variables, VariableMap localVariables) {
        this.caseService = caseService;
        this.variables = variables;
        this.localVariables = localVariables;
    }

    public CaseServiceStubBuilder(CaseService caseService) {
        this(caseService, Variables.createVariables(), Variables.createVariables());
    }

    public <T> CaseServiceStubBuilder define(VariableFactory<T> variableFactory) {
        this.factories.add(variableFactory);
        return this;
    }

    public <T> CaseServiceStubBuilder defineAndInitialize(VariableFactory<T> variableFactory, T initialValue) {
        this.define(variableFactory);
        variableFactory.on(this.variables).set(initialValue);
        return this;
    }

    public <T> CaseServiceStubBuilder defineAndInitializeLocal(VariableFactory<T> variableFactory, T initialValue) {
        this.define(variableFactory);
        variableFactory.on(this.localVariables).set(initialValue);
        return this;
    }

    public CaseService build() {
        this.factories.forEach(factory -> {
            ((CaseService)Mockito.doAnswer(invocation -> factory.from(this.variables).get()).when((Object)this.caseService)).getVariable(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)factory.getName()));
            ((CaseService)Mockito.doAnswer(invocation -> this.variables.put((Object)factory.getName(), invocation.getArguments()[2])).when((Object)this.caseService)).setVariable(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)factory.getName()), ArgumentMatchers.any());
            ((CaseService)Mockito.doAnswer(invocation -> this.variables).when((Object)this.caseService)).getVariables(ArgumentMatchers.anyString());
            ((CaseService)Mockito.doAnswer(invocation -> {
                List requestedVariableNames = (List)invocation.getArguments()[1];
                return this.variables.entrySet().stream().filter(variable -> requestedVariableNames.contains(variable.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
            }).when((Object)this.caseService)).getVariables(ArgumentMatchers.anyString(), (Collection)ArgumentMatchers.anyList());
            ((CaseService)Mockito.doAnswer(invocation -> factory.from(this.localVariables).get()).when((Object)this.caseService)).getVariableLocal(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)factory.getName()));
            ((CaseService)Mockito.doAnswer(invocation -> this.localVariables.put((Object)factory.getName(), invocation.getArguments()[2])).when((Object)this.caseService)).setVariableLocal(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)factory.getName()), ArgumentMatchers.any());
            ((CaseService)Mockito.doAnswer(invocation -> this.localVariables).when((Object)this.caseService)).getVariablesLocal(ArgumentMatchers.anyString());
            ((CaseService)Mockito.doAnswer(invocation -> {
                List requestedVariableNames = (List)invocation.getArguments()[1];
                return this.localVariables.entrySet().stream().filter(variable -> requestedVariableNames.contains(variable.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
            }).when((Object)this.caseService)).getVariablesLocal(ArgumentMatchers.anyString(), (Collection)ArgumentMatchers.anyList());
        });
        return this.caseService;
    }
}

