/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.mockito.mock;

import io.holunda.camunda.bpm.data.factory.VariableFactory;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Map;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.mockito.Mockito;

public abstract class FluentMock<T, P extends VariableScope> {
    protected final T mock;
    protected final Class<P> parameterType;

    protected FluentMock(T mock, Class<P> parameterType) {
        this.mock = mock;
        this.parameterType = parameterType;
    }

    protected void setVariables(VariableScope variableScope, Map<String, Object> variables) {
        if (variables == null || variables.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> variable : variables.entrySet()) {
            variableScope.setVariable(variable.getKey(), variable.getValue());
        }
    }

    protected static VariableMap[] combineVariableMaps(VariableMap variableMap, VariableMap ... values) {
        ArrayDeque<VariableMap> combinedVariableMaps = new ArrayDeque<VariableMap>(Arrays.asList(values));
        combinedVariableMaps.addFirst(variableMap);
        return (VariableMap[])combinedVariableMaps.toArray(VariableMap[]::new);
    }

    protected void setVariablesForMultipleInvocations(VariableMap[] variables, String invocationCountVariableName, VariableScope variableScope) {
        Object invocationCount = this.calculateInvocationCount(invocationCountVariableName, variableScope);
        if (invocationCount instanceof Integer) {
            int count = (Integer)invocationCount;
            variableScope.setVariable(invocationCountVariableName, (Object)(count + 1));
            this.setVariablesForGivenInvocationCount(variables, variableScope, count);
        }
    }

    private void setVariablesForGivenInvocationCount(VariableMap[] variables, VariableScope variableScope, int count) {
        if (count - 1 < variables.length) {
            this.setVariables(variableScope, (Map<String, Object>)variables[count - 1]);
        } else {
            this.setVariables(variableScope, (Map<String, Object>)variables[variables.length - 1]);
        }
    }

    private Object calculateInvocationCount(String countVariable, VariableScope variableScope) {
        Object executionCount = variableScope.getVariable(countVariable);
        if (executionCount == null) {
            variableScope.setVariable(countVariable, (Object)1);
            executionCount = 1;
        }
        return executionCount;
    }

    public abstract void onExecutionSetVariables(VariableMap var1);

    public abstract void onExecutionSetVariables(VariableMap var1, VariableMap ... var2);

    public void onExecutionSetVariable(String key, Object value) {
        this.onExecutionSetVariables(Variables.putValue((String)key, (Object)value));
    }

    public <V> void onExecutionSetVariable(VariableFactory<V> variable, V value) {
        this.onExecutionSetVariable(variable.getName(), value);
    }

    @SafeVarargs
    public final void onExecutionSetVariables(Map<String, Object> variables, Map<String, Object> ... values) {
        this.onExecutionSetVariables(Variables.fromMap(variables), (VariableMap[])Arrays.stream(values).map(Variables::fromMap).toArray(VariableMap[]::new));
    }

    public void onExecutionSetVariables(Map<String, Object> variables) {
        this.onExecutionSetVariables(Variables.fromMap(variables));
    }

    public void onExecutionThrowBpmnError(String errorCode) {
        this.onExecutionThrowBpmnError(new BpmnError(errorCode));
    }

    public void onExecutionThrowBpmnError(String errorCode, String message) {
        this.onExecutionThrowBpmnError(new BpmnError(errorCode, message));
    }

    public abstract void onExecutionThrowBpmnError(BpmnError var1);

    public abstract void onExecutionThrowException(Exception var1);

    public T getMock() {
        return this.mock;
    }

    protected P any() {
        return (P)((VariableScope)Mockito.any(this.parameterType));
    }
}

