/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.mockito.answer;

import javax.annotation.Nonnull;
import org.camunda.bpm.engine.query.Query;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public final class FluentAnswer<T extends Query<?, R>, R>
implements Answer<T> {
    private final Class<T> type;

    public static <T extends Query<?, R>, R> T createMock(Class<T> type) {
        return (T)((Query)Mockito.mock(type, FluentAnswer.createAnswer(type)));
    }

    public static <T extends Query<?, R>, R> FluentAnswer<T, R> createAnswer(Class<T> type) {
        return new FluentAnswer<T, R>(type);
    }

    private FluentAnswer(Class<T> type) {
        this.type = type;
    }

    public T answer(@Nonnull InvocationOnMock invocation) throws Throwable {
        Class<?> methodReturnType = invocation.getMethod().getReturnType();
        if (this.type.isAssignableFrom(methodReturnType) || Query.class.isAssignableFrom(methodReturnType)) {
            Object mock = invocation.getMock();
            return (T)((Query)mock);
        }
        return null;
    }
}

