/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.mockito.function;

import java.io.StringWriter;
import java.net.URL;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class ReadXmlDocumentFromResource
implements Function<URL, Document> {
    public static Function<Document, String> TO_STRING = new Function<Document, String>(){

        @Override
        @Nonnull
        public String apply(Document document) {
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                StringWriter writer = new StringWriter();
                transformer.transform(new DOMSource(document), new StreamResult(writer));
                return writer.getBuffer().toString();
            }
            catch (TransformerException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public ReadXmlDocumentFromResource() {
        this.factory.setNamespaceAware(true);
    }

    @Override
    public Document apply(URL xmlResource) {
        try {
            Document document = this.factory.newDocumentBuilder().parse(xmlResource.openStream());
            document.getDocumentElement().normalize();
            return document;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

