/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.mockito;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.test.mock.Mocks;
import org.camunda.community.mockito.function.CreateInstance;
import org.camunda.community.mockito.function.NameForType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Expressions
extends Enum<Expressions> {
    private static final Logger LOG;
    private static final /* synthetic */ Expressions[] $VALUES;

    public static Expressions[] values() {
        return (Expressions[])$VALUES.clone();
    }

    public static Expressions valueOf(String name) {
        return Enum.valueOf(Expressions.class, name);
    }

    public static void registerMockInstancesForNestedTypes(Class<?> parentClass) {
        Expressions.findNestedClasses(parentClass).forEach(Expressions::registerMockInstance);
    }

    private static Collection<Class<?>> findNestedClasses(Class<?> parentClass) {
        ArrayList result = new ArrayList();
        for (Class<?> nestedClass : parentClass.getDeclaredClasses()) {
            int modifiers = nestedClass.getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) continue;
            result.add(nestedClass);
        }
        return result;
    }

    public static void registerInstancesForFields(Object instance) {
        if (instance == null) {
            throw new IllegalArgumentException("instance must not be null!");
        }
        for (Field field : instance.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Object value = field.get(instance);
                if (value == null) continue;
                Expressions.registerInstance(NameForType.juelNameFor(field.getType()), value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void registerNewInstancesForNestedTypes(Class<?> parentClass) {
        Expressions.findNestedClasses(parentClass).forEach(Expressions::registerNewInstance);
    }

    public static void registerMockInstances(Class<?> ... types) {
        if (types == null) {
            throw new IllegalArgumentException("types must not be null!");
        }
        Expressions.registerMockInstances(Arrays.asList(types));
    }

    public static void registerMockInstances(Collection<Class<?>> types) {
        types.forEach(Expressions::registerMockInstance);
    }

    public static <T> T registerMockInstance(String name, Class<T> type) {
        return Expressions.registerInstance(name, CreateInstance.mockInstance(type));
    }

    public static <T> T registerMockInstance(Class<T> type) {
        return Expressions.registerMockInstance(NameForType.juelNameFor(type), type);
    }

    public static <T> T registerNewInstance(String name, Class<T> type) {
        return Expressions.registerInstance(name, CreateInstance.newInstanceByDefaultConstructor(type));
    }

    public static <T> T registerNewInstance(Class<T> type) {
        return Expressions.registerNewInstance(NameForType.juelNameFor(type), type);
    }

    public static <T> T registerInstance(T instance) {
        return Expressions.registerInstance(NameForType.juelNameFor(instance), instance);
    }

    public static <T> T registerInstance(String name, T instance) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name must not be blank!");
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance must not be null!");
        }
        LOG.debug(String.format("registered instance: name=%s, value=%s", name, instance));
        Mocks.register((String)name, instance);
        return instance;
    }

    public static <T> T getRegistered(String name) {
        Object mock = Mocks.get((Object)name);
        if (mock == null) {
            throw new IllegalStateException("no instance registered for name=" + name);
        }
        return (T)mock;
    }

    public static <T> T getRegistered(Class<?> type) {
        return Expressions.getRegistered(NameForType.juelNameFor(type));
    }

    public static void reset() {
        Mocks.reset();
    }

    private static /* synthetic */ Expressions[] $values() {
        return new Expressions[0];
    }

    static {
        $VALUES = Expressions.$values();
        LOG = LoggerFactory.getLogger(Expressions.class);
    }
}

