/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.mockito.function;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.camunda.community.mockito.DelegateExpressions;
import org.camunda.community.mockito.function.ReadXmlDocumentFromResource;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParseDelegateExpressions
implements Function<URL, List<Pair<ExpressionType, String>>> {
    static final String PATTERN_DELEGATE_EXPRESSION = "[#$]\\{([^}]+)}";

    public static String extractDelegateExpressionName(String delegateExpression) {
        return StringUtils.isNotBlank((CharSequence)delegateExpression) ? delegateExpression.replaceAll(PATTERN_DELEGATE_EXPRESSION, "$1") : null;
    }

    static Pair<ExpressionType, String> extractDelegateExpressionName(Pair<ExpressionType, Node> pair) {
        String delegateExpression = ((Node)pair.getRight()).getTextContent();
        return Pair.of((Object)((Object)((ExpressionType)((Object)pair.getLeft()))), StringUtils.isNotBlank((CharSequence)delegateExpression) ? delegateExpression.replaceAll(PATTERN_DELEGATE_EXPRESSION, "$1") : null);
    }

    @Override
    public List<Pair<ExpressionType, String>> apply(URL bpmnResource) {
        Element root = new ReadXmlDocumentFromResource().apply(bpmnResource).getDocumentElement();
        List nodeListsPerType = Stream.of(ExpressionType.values()).flatMap(type -> type.elements.stream().map(it -> root.getElementsByTagNameNS("*", (String)it)).map(it -> Pair.of((Object)type, (Object)it))).toList();
        return nodeListsPerType.stream().flatMap(typeToNodeList -> ParseDelegateExpressions.streamOf((NodeList)typeToNodeList.getRight()).map(node -> {
            NamedNodeMap attributes = node.getAttributes();
            Node delegateExpression = Optional.ofNullable(attributes.getNamedItem("delegateExpression")).orElse(attributes.getNamedItem("camunda:delegateExpression"));
            return Pair.of((Object)((Object)((ExpressionType)((Object)((Object)((Object)typeToNodeList.getLeft()))))), (Object)delegateExpression);
        })).filter(it -> it.getRight() != null).map(ParseDelegateExpressions::extractDelegateExpressionName).toList();
    }

    private static Stream<Node> streamOf(final NodeList nodeList) {
        final long length = nodeList.getLength();
        Iterator<Node> iterator = new Iterator<Node>(){
            private final AtomicInteger index = new AtomicInteger(0);

            @Override
            public boolean hasNext() {
                return (long)this.index.get() < length;
            }

            @Override
            public Node next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return nodeList.item(this.index.getAndIncrement());
            }
        };
        Spliterator<Node> spliterator = Spliterators.spliterator(iterator, length, 16);
        return StreamSupport.stream(spliterator, false);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ExpressionType {
        EXECUTION_LISTENER("executionListener"){

            @Override
            public void registerMock(String name) {
                DelegateExpressions.registerExecutionListenerMock(name);
            }
        }
        ,
        TASK_LISTENER("taskListener"){

            @Override
            public void registerMock(String name) {
                DelegateExpressions.registerTaskListenerMock(name);
            }
        }
        ,
        JAVA_DELEGATE((Set)Set.of("serviceTask", "messageEventDefinition")){

            @Override
            public void registerMock(String name) {
                DelegateExpressions.registerJavaDelegateMock(name);
            }
        };

        private final Set<String> elements;

        private ExpressionType(String element) {
            this.elements = Set.of(element);
        }

        private ExpressionType(Set<String> elements) {
            this.elements = elements;
        }

        public abstract void registerMock(String var1);
    }
}

