/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.mockito.verify;

import io.holunda.camunda.bpm.data.factory.VariableFactory;
import org.camunda.bpm.engine.RuntimeService;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class RuntimeServiceVerification {
    private final RuntimeService runtimeService;

    public RuntimeServiceVerification(RuntimeService runtimeService) {
        this.runtimeService = runtimeService;
    }

    public <T> void verifyGet(VariableFactory<T> variableFactory, String executionId, VerificationMode mode) {
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)mode)).getVariable(executionId, variableFactory.getName());
    }

    public <T> void verifyGet(VariableFactory<T> variableFactory, String executionId) {
        this.verifyGet(variableFactory, executionId, Mockito.times((int)1));
    }

    public <T> void verifyGetLocal(VariableFactory<T> variableFactory, String executionId, VerificationMode mode) {
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)mode)).getVariableLocal(executionId, variableFactory.getName());
    }

    public <T> void verifyGetLocal(VariableFactory<T> variableFactory, String executionId) {
        this.verifyGetLocal(variableFactory, executionId, Mockito.times((int)1));
    }

    public <T> void verifySet(VariableFactory<T> variableFactory, T value, String executionId, VerificationMode mode) {
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)mode)).setVariable(executionId, variableFactory.getName(), (Object)variableFactory.on(this.runtimeService, executionId).getTypedValue(value, false));
    }

    public <T> void verifySet(VariableFactory<T> variableFactory, T value, String executionId) {
        this.verifySet(variableFactory, value, executionId, Mockito.times((int)1));
    }

    public <T> void verifySetLocal(VariableFactory<T> variableFactory, T value, String executionId, VerificationMode mode) {
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)mode)).setVariableLocal(executionId, variableFactory.getName(), (Object)variableFactory.on(this.runtimeService, executionId).getTypedValue(value, false));
    }

    public <T> void verifySetLocal(VariableFactory<T> variableFactory, T value, String executionId) {
        this.verifySetLocal(variableFactory, value, executionId, Mockito.times((int)1));
    }

    public <T> void verifyRemove(VariableFactory<T> variableFactory, String executionId, VerificationMode mode) {
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)mode)).removeVariable(executionId, variableFactory.getName());
    }

    public <T> void verifyRemove(VariableFactory<T> variableFactory, String executionId) {
        ((RuntimeService)Mockito.verify((Object)this.runtimeService)).removeVariable(executionId, variableFactory.getName());
    }

    public <T> void verifyRemoveLocal(VariableFactory<T> variableFactory, String executionId, VerificationMode mode) {
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)mode)).removeVariableLocal(executionId, variableFactory.getName());
    }

    public <T> void verifyRemoveLocal(VariableFactory<T> variableFactory, String executionId) {
        ((RuntimeService)Mockito.verify((Object)this.runtimeService)).removeVariableLocal(executionId, variableFactory.getName());
    }

    public void verifyGetVariables(String executionId, VerificationMode mode) {
        ((RuntimeService)Mockito.verify((Object)this.runtimeService, (VerificationMode)mode)).getVariables(executionId);
    }

    public void verifyGetVariables(String executionId) {
        ((RuntimeService)Mockito.verify((Object)this.runtimeService)).getVariables(executionId);
    }

    public void verifyNoMoreInteractions() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.runtimeService});
    }
}

