/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.templateengines;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XQueryOperator {
    private Configuration configuration;
    private XQueryExpression xQueryExpression;
    private Properties outputProperties;

    public static XQueryOperatorBuilder builder() {
        return new XQueryOperatorBuilder();
    }

    public XQueryOperator(Configuration configuration, XQueryExpression xQueryExpression, Properties outputProperties) {
        this.configuration = configuration;
        this.xQueryExpression = xQueryExpression;
        this.outputProperties = outputProperties;
    }

    public void evaluate(Result result, Object ... parameters) throws TransformerException {
        DynamicQueryContext context = new DynamicQueryContext(this.configuration);
        if (parameters.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < parameters.length; i += 2) {
            Object value = parameters[i + 1];
            Sequence sequence = this.mapValue(value);
            context.setParameter(new StructuredQName("", "", (String)parameters[i]), sequence);
        }
        this.evaluate(context, result, this.outputProperties);
    }

    private Sequence mapValue(Object value) throws XPathException {
        Object sequence;
        if (value instanceof Document) {
            sequence = new DocumentWrapper((Node)((Document)value), "", this.configuration);
        } else if (value instanceof CharSequence) {
            sequence = StringValue.makeStringValue((CharSequence)((CharSequence)value));
        } else if (value instanceof Boolean) {
            sequence = (Boolean)value != false ? BooleanValue.TRUE : BooleanValue.FALSE;
        } else if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            Number n = (Number)value;
            sequence = Int64Value.makeIntegerValue((long)n.longValue());
        } else if (value instanceof Double) {
            Double b = (Double)value;
            sequence = DoubleValue.makeDoubleValue((double)b);
        } else if (value instanceof Float) {
            Float b = (Float)value;
            sequence = FloatValue.makeFloatValue((float)b.floatValue());
        } else {
            sequence = value instanceof Date ? DateTimeValue.fromJavaDate((Date)((Date)value)) : new ObjectValue(value);
        }
        return sequence;
    }

    public void evaluate(Result result, Map<String, Object> parameters) throws TransformerException {
        DynamicQueryContext context = new DynamicQueryContext(this.configuration);
        for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
            Object value = parameter.getValue();
            Sequence sequence = this.mapValue(value);
            context.setParameter(new StructuredQName("", "", parameter.getKey()), sequence);
        }
        this.evaluate(context, result, this.outputProperties);
    }

    public void evaluate(DynamicQueryContext env, Result result, Properties outputProperties) throws TransformerException {
        this.xQueryExpression.run(env, result, outputProperties);
    }

    public String evaluateToString(Object ... parameters) throws TransformerException {
        StringWriter outWriter = new StringWriter();
        StreamResult result = new StreamResult(outWriter);
        this.evaluate((Result)result, parameters);
        return outWriter.toString();
    }

    public String evaluateToString(Map<String, Object> parameters) throws TransformerException {
        StringWriter outWriter = new StringWriter();
        StreamResult result = new StreamResult(outWriter);
        this.evaluate((Result)result, parameters);
        return outWriter.toString();
    }

    public static class XQueryOperatorBuilder {
        private Configuration configuration;
        private Properties outputProperties;
        private Boolean indent;
        private Object stylesheet;
        private String encoding = "UTF-8";

        public XQueryOperator build() throws Exception {
            XQueryExpression xQueryExpression;
            if (this.configuration == null) {
                this.configuration = new Configuration();
            }
            if (this.outputProperties == null) {
                this.outputProperties = this.getDefaultOutputProperties();
            }
            if (this.indent != null) {
                this.outputProperties.setProperty("indent", this.indent != false ? "yes" : "no");
            }
            StaticQueryContext staticQueryContext = this.configuration.newStaticQueryContext();
            if (this.stylesheet instanceof byte[]) {
                xQueryExpression = staticQueryContext.compileQuery((InputStream)new ByteArrayInputStream((byte[])this.stylesheet), this.encoding);
            } else if (this.stylesheet instanceof Reader) {
                xQueryExpression = staticQueryContext.compileQuery((Reader)this.stylesheet);
            } else {
                throw new IllegalArgumentException();
            }
            return new XQueryOperator(this.configuration, xQueryExpression, this.outputProperties);
        }

        public XQueryOperatorBuilder withIndent(boolean indent) {
            this.indent = indent;
            return this;
        }

        private Properties getDefaultOutputProperties() {
            Properties outputProperties = new Properties();
            outputProperties.setProperty("omit-xml-declaration", "yes");
            outputProperties.setProperty("indent", "no");
            return outputProperties;
        }

        public XQueryOperatorBuilder withConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public XQueryOperatorBuilder withStylesheet(byte[] stylesheet) throws IOException {
            this.stylesheet = stylesheet;
            return this;
        }

        public XQueryOperatorBuilder withStylesheet(Reader stylesheet) throws IOException {
            this.stylesheet = stylesheet;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public XQueryOperatorBuilder withStylesheetResource(String stylesheet) throws IOException {
            InputStream in = XQueryOperatorBuilder.class.getResourceAsStream(stylesheet);
            if (in == null) {
                throw new FileNotFoundException("Unknown resource " + stylesheet);
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            try {
                int read;
                while ((read = in.read(buffer)) != -1) {
                    bout.write(buffer, 0, read);
                }
            }
            finally {
                in.close();
            }
            this.stylesheet = bout.toByteArray();
            return this;
        }

        public XQueryOperatorBuilder withOutputProperties(Properties properties) {
            this.outputProperties = properties;
            return this;
        }

        public XQueryOperatorBuilder withCharacterEncoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public XQueryOperatorBuilder withExtensionFunctionDefinition(ExtensionFunctionDefinition function) {
            if (this.configuration == null) {
                this.configuration = new Configuration();
            }
            this.configuration.registerExtensionFunction(function);
            return this;
        }
    }
}

