/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.templateengines;

import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import net.sf.saxon.Configuration;
import org.camunda.templateengines.XQueryCompiledScript;
import org.camunda.templateengines.XQueryOperator;
import org.camunda.templateengines.XQueryScriptEngineFactory;

public class XQueryScriptEngine
extends AbstractScriptEngine
implements Compilable {
    protected ScriptEngineFactory scriptEngineFactory;
    protected Configuration configuration;
    protected Properties properties;

    public XQueryScriptEngine() {
        this((ScriptEngineFactory)null);
    }

    public XQueryScriptEngine(ScriptEngineFactory scriptEngineFactory) {
        this.scriptEngineFactory = scriptEngineFactory;
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        return this.eval((Reader)new StringReader(script), context);
    }

    @Override
    public Object eval(Reader script, ScriptContext context) throws ScriptException {
        this.initConfiguration();
        Bindings bindings = context.getBindings(100);
        try {
            XQueryOperator operator = XQueryOperator.builder().withStylesheet(script).withOutputProperties(this.properties).withConfiguration(this.configuration).build();
            return operator.evaluateToString(bindings);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptEngineFactory getFactory() {
        if (this.scriptEngineFactory == null) {
            XQueryScriptEngine xQueryScriptEngine = this;
            synchronized (xQueryScriptEngine) {
                if (this.scriptEngineFactory == null) {
                    this.scriptEngineFactory = new XQueryScriptEngineFactory();
                }
            }
        }
        return this.scriptEngineFactory;
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        return this.compile(new StringReader(script));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initConfiguration() {
        XQueryScriptEngine xQueryScriptEngine;
        if (this.configuration == null) {
            xQueryScriptEngine = this;
            synchronized (xQueryScriptEngine) {
                if (this.configuration == null) {
                    this.configuration = new Configuration();
                }
            }
        }
        if (this.properties == null) {
            xQueryScriptEngine = this;
            synchronized (xQueryScriptEngine) {
                if (this.properties == null) {
                    this.properties = new Properties();
                    this.properties.setProperty("omit-xml-declaration", "yes");
                    this.properties.setProperty("indent", "no");
                }
            }
        }
    }

    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        this.initConfiguration();
        return new XQueryCompiledScript((ScriptEngine)this, script, this.configuration, this.properties);
    }
}

