/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.xslt;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import java.util.Properties;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.camunda.bpm.extension.xslt.XsltCompiledScript;
import org.camunda.commons.utils.IoUtil;

public class XsltScriptEngine
extends AbstractScriptEngine
implements Compilable {
    protected ScriptEngineFactory scriptEngineFactory;

    public XsltScriptEngine() {
        this((ScriptEngineFactory)null);
    }

    public XsltScriptEngine(ScriptEngineFactory scriptEngineFactory) {
        this.scriptEngineFactory = scriptEngineFactory;
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        return this.compile(new StringReader(script));
    }

    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        try {
            TransformerFactoryImpl factory = new TransformerFactoryImpl();
            Templates templates = factory.newTemplates(new StreamSource(script));
            return new XsltCompiledScript(this, templates);
        }
        catch (TransformerException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        return this.eval((Reader)new StringReader(script), context);
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        Transformer transformer;
        try {
            TransformerFactoryImpl factory = new TransformerFactoryImpl();
            transformer = factory.newTransformer(new StreamSource(reader));
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        return this.evaluate(transformer, context);
    }

    public Object evaluate(Transformer transformer, ScriptContext context) throws ScriptException {
        StringWriter writer = new StringWriter();
        Bindings bindings = context.getBindings(100);
        Properties properties = (Properties)context.getAttribute("properties", 100);
        try {
            String source;
            transformer.clearParameters();
            if (properties != null && !properties.isEmpty()) {
                transformer.setOutputProperties(properties);
            }
            if ((source = (String)bindings.get("camunda_source")) == null) {
                throw new IllegalArgumentException("variable 'camunda_source' is not set. The XSLT transformation requires variable 'camunda_source' to be set.");
            }
            bindings.remove("camunda_source");
            if (!bindings.isEmpty()) {
                for (Map.Entry entry : bindings.entrySet()) {
                    if (entry.getValue() == null) continue;
                    transformer.setParameter((String)entry.getKey(), entry.getValue());
                }
            }
            transformer.transform(new StreamSource(IoUtil.stringAsInputStream((String)source)), new StreamResult(writer));
            writer.flush();
        }
        catch (TransformerException e) {
            throw new ScriptException(e);
        }
        return writer.toString();
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.scriptEngineFactory;
    }
}

