/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.xslt;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.camunda.bpm.extension.xslt.XsltScriptEngine;
import org.camunda.commons.utils.StringUtil;

public class XsltScriptEngineFactory
implements ScriptEngineFactory {
    public static final String NAME = "xslt";
    public static final String VERSION = "2.0";
    public static final List<String> names = Collections.unmodifiableList(Arrays.asList("xslt", "XSLT", "Xslt"));
    public static final List<String> extensions = Collections.unmodifiableList(Collections.singletonList("xsl"));
    public static final List<String> mimeTypes = Collections.unmodifiableList(Arrays.asList("text/xml", "application/xml", "application/xslt+xml"));

    @Override
    public String getEngineName() {
        return NAME;
    }

    @Override
    public String getEngineVersion() {
        return VERSION;
    }

    @Override
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    public List<String> getMimeTypes() {
        return mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return names;
    }

    @Override
    public String getLanguageName() {
        return NAME;
    }

    @Override
    public String getLanguageVersion() {
        return VERSION;
    }

    @Override
    public Object getParameter(String key) {
        if (key.equals("javax.script.name")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        return null;
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        throw new UnsupportedOperationException("getMethodCallSyntax");
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        throw new UnsupportedOperationException("getOutputStatement");
    }

    @Override
    public String getProgram(String ... statements) {
        return StringUtil.join((String)"\n", (String[])statements);
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new XsltScriptEngine(this);
    }
}

