/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.vanillabp.c7.service;

import io.vanillabp.springboot.adapter.ProcessServiceImplementation;
import java.util.Objects;
import java.util.function.Function;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.MessageCorrelationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.community.vanillabp.c7.service.WakupJobExecutorNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.repository.CrudRepository;
import org.springframework.transaction.annotation.Transactional;

public class Camunda7ProcessService<DE>
implements ProcessServiceImplementation<DE> {
    private static final Logger logger = LoggerFactory.getLogger(Camunda7ProcessService.class);
    private final ApplicationEventPublisher applicationEventPublisher;
    private final ProcessEngine processEngine;
    private final CrudRepository<DE, String> workflowAggregateRepository;
    private final Class<DE> workflowAggregateClass;
    private final Function<DE, String> getWorkflowAggregateId;
    private String workflowModuleId;
    private String bpmnProcessId;

    public Camunda7ProcessService(ApplicationEventPublisher applicationEventPublisher, ProcessEngine processEngine, Function<DE, String> getWorkflowAggregateId, CrudRepository<DE, String> workflowAggregateRepository, Class<DE> workflowAggregateClass) {
        this.applicationEventPublisher = applicationEventPublisher;
        this.processEngine = processEngine;
        this.workflowAggregateRepository = workflowAggregateRepository;
        this.workflowAggregateClass = workflowAggregateClass;
        this.getWorkflowAggregateId = getWorkflowAggregateId;
    }

    public void wire(String workflowModuleId, String bpmnProcessId) {
        this.workflowModuleId = workflowModuleId;
        this.bpmnProcessId = bpmnProcessId;
    }

    public boolean testForNotYetWired() {
        if (this.bpmnProcessId == null) {
            logger.error("The bean ProcessService<{}> was not wired to a BPMN process! It is likely that the BPMN is not part of the classpath.", (Object)this.workflowAggregateClass.getName());
            return true;
        }
        return false;
    }

    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    public Class<DE> getWorkflowAggregateClass() {
        return this.workflowAggregateClass;
    }

    public CrudRepository<DE, String> getWorkflowAggregateRepository() {
        return this.workflowAggregateRepository;
    }

    public DE startWorkflow(DE workflowAggregate) throws Exception {
        Object attachedAggregate = this.workflowAggregateRepository.save(workflowAggregate);
        String id = this.getWorkflowAggregateId.apply(attachedAggregate).toString();
        this.wakeupJobExecutorOnActivity();
        this.processEngine.getRuntimeService().createProcessInstanceByKey(this.bpmnProcessId).businessKey(id).processDefinitionTenantId(this.workflowModuleId).execute();
        return (DE)this.workflowAggregateRepository.save(attachedAggregate);
    }

    @Transactional
    public DE correlateMessage(DE workflowAggregate, String messageName) {
        return this.correlateMessage(workflowAggregate, messageName, null, null);
    }

    public DE correlateMessage(DE workflowAggregate, Object message) {
        return this.correlateMessage(workflowAggregate, message.getClass().getSimpleName());
    }

    public DE correlateMessage(DE workflowAggregate, String messageName, String correlationId) {
        String correlationIdLocalVariableName = this.bpmnProcessId + "-" + messageName;
        return this.correlateMessage(workflowAggregate, messageName, correlationIdLocalVariableName, correlationId);
    }

    public DE correlateMessage(DE workflowAggregate, Object message, String correlationId) {
        return this.correlateMessage(workflowAggregate, message.getClass().getSimpleName(), correlationId);
    }

    private DE correlateMessage(DE workflowAggregate, String messageName, String correlationIdLocalVariableName, String correlationId) {
        String originalId = this.getWorkflowAggregateId.apply(workflowAggregate);
        boolean isNewEntity = Objects.isNull(originalId);
        Object attachedAggregate = this.workflowAggregateRepository.save(workflowAggregate);
        String id = (isNewEntity ? this.getWorkflowAggregateId.apply(attachedAggregate) : originalId).toString();
        MessageCorrelationBuilder correlation = this.processEngine.getRuntimeService().createMessageCorrelation(messageName).processInstanceBusinessKey(id);
        if (correlationIdLocalVariableName != null) {
            correlation.localVariableEquals(correlationIdLocalVariableName, (Object)correlationId);
        }
        this.wakeupJobExecutorOnActivity();
        if (isNewEntity) {
            ProcessInstance result = correlation.correlateStartMessage();
            logger.trace("Started process '{}#{}' by message-correlation '{}' (tenant: {})", new Object[]{this.bpmnProcessId, result.getProcessInstanceId(), messageName, result.getTenantId()});
        } else {
            Execution result = correlation.correlateWithResult().getExecution();
            logger.trace("Correlated message '{}' using correlation-id '{}' for process '{}#{}' and execution '{}' (tenant: {})", new Object[]{messageName, correlationId, this.bpmnProcessId, result.getProcessInstanceId(), result.getId(), result.getTenantId()});
        }
        return (DE)attachedAggregate;
    }

    public DE completeUserTask(DE workflowAggregate, String taskId) {
        Object attachedAggregate = this.workflowAggregateRepository.save(workflowAggregate);
        this.wakeupJobExecutorOnActivity();
        this.processEngine.getTaskService().complete(taskId);
        return (DE)attachedAggregate;
    }

    public DE completeTask(DE workflowAggregate, String taskId) {
        throw new UnsupportedOperationException();
    }

    public DE cancelTask(DE workflowAggregate, String taskId, String bpmnErrorCode) {
        throw new UnsupportedOperationException();
    }

    public DE cancelUserTask(DE workflowAggregate, String taskId, String errorCode) {
        Object attachedAggregate = this.workflowAggregateRepository.save(workflowAggregate);
        this.wakeupJobExecutorOnActivity();
        this.processEngine.getTaskService().handleBpmnError(taskId, errorCode);
        return (DE)attachedAggregate;
    }

    private void wakeupJobExecutorOnActivity() {
        logger.debug("Wanna wake up job-executor");
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new WakupJobExecutorNotification(this.getClass().getName()));
    }
}

