/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.vanillabp.c7.wiring;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.model.bpmn.instance.FlowElement;
import org.camunda.bpm.model.bpmn.instance.UserTask;
import org.camunda.community.vanillabp.c7.wiring.Camunda7Connectable;
import org.camunda.community.vanillabp.c7.wiring.Camunda7UserTaskHandler;

public class Camunda7UserTaskEventHandler
implements TaskListener {
    private final Map<Camunda7Connectable, Camunda7UserTaskHandler> taskHandlers = new HashMap<Camunda7Connectable, Camunda7UserTaskHandler>();

    public void addTaskHandler(Camunda7Connectable connectable, Camunda7UserTaskHandler taskHandler) {
        this.taskHandlers.put(connectable, taskHandler);
    }

    public void notify(DelegateTask delegateTask) {
        ExecutionEntity execution = (ExecutionEntity)delegateTask.getExecution();
        String bpmnProcessId = execution.getProcessDefinition().getKey();
        Map.Entry handler = this.taskHandlers.entrySet().stream().filter(entry -> {
            Camunda7Connectable connectable = (Camunda7Connectable)entry.getKey();
            if (!connectable.getBpmnProcessId().equals(bpmnProcessId)) {
                return false;
            }
            FlowElement element = execution.getBpmnModelElementInstance();
            if (element == null) {
                return false;
            }
            return connectable.applies(element.getId(), ((UserTask)element).getCamundaFormKey());
        }).filter(entry -> ((Camunda7UserTaskHandler)((Object)((Object)entry.getValue()))).eventApplies(delegateTask.getEventName())).findFirst().orElseThrow(() -> new RuntimeException("The is no method annotated by '@WorkflowTask(id = \"" + delegateTask.getTaskDefinitionKey() + "\") in any class annotated by @WorkflowService(bpmnProcess = @BpmnProcess(bpmnProcessId = \"" + bpmnProcessId + "\"))!"));
        ((Camunda7UserTaskHandler)((Object)handler.getValue())).notify(delegateTask);
    }
}

