/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.vanillabp.c7.wiring;

import io.vanillabp.spi.service.TaskEvent;
import io.vanillabp.springboot.adapter.MultiInstance;
import io.vanillabp.springboot.adapter.TaskHandlerBase;
import io.vanillabp.springboot.parameters.MethodParameter;
import io.vanillabp.springboot.parameters.TaskEventMethodParameter;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.community.vanillabp.c7.wiring.Camunda7TaskHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.repository.CrudRepository;

public class Camunda7UserTaskHandler
extends TaskHandlerBase
implements TaskListener {
    private static final Logger logger = LoggerFactory.getLogger(Camunda7UserTaskHandler.class);

    public Camunda7UserTaskHandler(CrudRepository<Object, String> workflowAggregateRepository, Object bean, Method method, List<MethodParameter> parameters) {
        super(workflowAggregateRepository, bean, method, parameters);
    }

    protected Logger getLogger() {
        return logger;
    }

    public void notify(DelegateTask delegateTask) {
        Map[] multiInstanceCache = new Map[]{null};
        try {
            DelegateExecution execution = delegateTask.getExecution();
            super.execute(execution.getBusinessKey(), multiInstanceActivity -> {
                if (multiInstanceCache[0] == null) {
                    multiInstanceCache[0] = Camunda7TaskHandler.getMultiInstanceContext(execution);
                }
                return multiInstanceCache[0].get(multiInstanceActivity);
            }, taskParameter -> execution.getVariableLocal(taskParameter), () -> delegateTask.getId(), () -> this.getTaskEvent(delegateTask.getEventName()));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean eventApplies(String eventName) {
        TaskEvent.Event event = this.getTaskEvent(eventName);
        if (event == null) {
            return false;
        }
        return this.parameters.stream().filter(parameter -> parameter instanceof TaskEventMethodParameter).map(parameter -> ((TaskEventMethodParameter)parameter).getEvents()).findFirst().orElse(Set.of()).contains(event);
    }

    protected TaskEvent.Event getTaskEvent(String eventName) {
        switch (eventName) {
            case "delete": {
                return TaskEvent.Event.CANCELED;
            }
            case "create": {
                return TaskEvent.Event.CREATED;
            }
        }
        return null;
    }

    protected MultiInstance<Object> getMultiInstance(String name, Function<String, Object> multiInstanceSupplier) {
        return (MultiInstance)multiInstanceSupplier.apply(name);
    }

    protected Object getMultiInstanceElement(String name, Function<String, Object> multiInstanceSupplier) {
        return ((MultiInstance)multiInstanceSupplier.apply(name)).getElement();
    }

    protected Integer getMultiInstanceTotal(String name, Function<String, Object> multiInstanceSupplier) {
        return ((MultiInstance)multiInstanceSupplier.apply(name)).getTotal();
    }

    protected Integer getMultiInstanceIndex(String name, Function<String, Object> multiInstanceSupplier) {
        return ((MultiInstance)multiInstanceSupplier.apply(name)).getIndex();
    }
}

