/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.vanillabp.c7.jobexecutor;

import java.util.Optional;
import javax.servlet.Filter;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.NotifyAcquisitionRejectedJobsHandler;
import org.camunda.bpm.engine.impl.jobexecutor.RejectedJobsHandler;
import org.camunda.bpm.engine.spring.components.jobexecutor.SpringJobExecutor;
import org.camunda.bpm.spring.boot.starter.property.CamundaBpmProperties;
import org.camunda.bpm.spring.boot.starter.property.JobExecutionProperty;
import org.camunda.community.vanillabp.c7.cockpit.WakeupFilter;
import org.camunda.community.vanillabp.c7.jobexecutor.WakeupJobExecutor;
import org.camunda.community.vanillabp.c7.service.WakupJobExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.TaskScheduler;

@Configuration
@AutoConfigureOrder(value=-2147483648)
@ConditionalOnProperty(prefix="camunda.bpm.job-execution", name={"wakeup"}, havingValue="true", matchIfMissing=false)
public class WakeupJobExecutorConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(WakeupJobExecutorConfiguration.class);
    @Value(value="${camunda.bpm.webapp.application-path:/camunda}")
    private String camundaWebAppBaseUrl;

    @Bean
    @Order(value=-1)
    public static JobExecutor jobExecutor(@Qualifier(value="camundaTaskExecutor") TaskExecutor taskExecutor, CamundaBpmProperties properties) {
        logger.info("VanillaBP's job-executor is using jobExecutorPreferTimerJobs=true and jobExecutorAcquireByDueDate=true. Please add DB-index according to https://docs.camunda.org/manual/7.6/user-guide/process-engine/the-job-executor/#the-job-order-of-job-acquisition");
        WakeupJobExecutor springJobExecutor = new WakeupJobExecutor();
        springJobExecutor.setTaskExecutor(taskExecutor);
        springJobExecutor.setRejectedJobsHandler((RejectedJobsHandler)new NotifyAcquisitionRejectedJobsHandler());
        JobExecutionProperty jobExecution = properties.getJobExecution();
        Optional.ofNullable(jobExecution.getLockTimeInMillis()).ifPresent(arg_0 -> ((SpringJobExecutor)springJobExecutor).setLockTimeInMillis(arg_0));
        Optional.ofNullable(jobExecution.getMaxJobsPerAcquisition()).ifPresent(arg_0 -> ((SpringJobExecutor)springJobExecutor).setMaxJobsPerAcquisition(arg_0));
        Optional.ofNullable(jobExecution.getWaitTimeInMillis()).ifPresent(arg_0 -> ((SpringJobExecutor)springJobExecutor).setWaitTimeInMillis(arg_0));
        Optional.ofNullable(jobExecution.getMaxWait()).ifPresent(arg_0 -> ((SpringJobExecutor)springJobExecutor).setMaxWait(arg_0));
        Optional.ofNullable(jobExecution.getBackoffTimeInMillis()).ifPresent(arg_0 -> ((SpringJobExecutor)springJobExecutor).setBackoffTimeInMillis(arg_0));
        Optional.ofNullable(jobExecution.getMaxBackoff()).ifPresent(arg_0 -> ((SpringJobExecutor)springJobExecutor).setMaxBackoff(arg_0));
        Optional.ofNullable(jobExecution.getBackoffDecreaseThreshold()).ifPresent(arg_0 -> ((SpringJobExecutor)springJobExecutor).setBackoffDecreaseThreshold(arg_0));
        Optional.ofNullable(jobExecution.getWaitIncreaseFactor()).ifPresent(arg_0 -> ((SpringJobExecutor)springJobExecutor).setWaitIncreaseFactor(arg_0));
        return springJobExecutor;
    }

    @Bean
    public WakupJobExecutorService wakupJobExecutorService(ProcessEngine processEngine) {
        return new WakupJobExecutorService(processEngine);
    }

    @Bean
    public FilterRegistrationBean<WakeupFilter> wakeupFilterForCockpit(ApplicationEventPublisher applicationEventPublisher, Optional<TaskScheduler> taskScheduler) {
        if (taskScheduler.isEmpty()) {
            throw new RuntimeException("To use wakeup job-executor you have to provide Spring Boot task scheduler! (For details see https://github.com/vanillabp/camunda7-adapter/blob/main/spring-boot/README.md#job-executor)");
        }
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new WakeupFilter(applicationEventPublisher, taskScheduler.get()));
        registrationBean.addUrlPatterns(new String[]{this.camundaWebAppBaseUrl + "/api/*"});
        registrationBean.setOrder(-1);
        return registrationBean;
    }

    @Bean
    @ConditionalOnProperty(prefix="camunda.bpm.job-execution", name={"wakeup"}, havingValue="true", matchIfMissing=false)
    public FilterRegistrationBean<WakeupFilter> wakeupFilterForRestApi(ApplicationEventPublisher applicationEventPublisher, Optional<TaskScheduler> taskScheduler) {
        if (taskScheduler.isEmpty()) {
            throw new RuntimeException("To use wakeup job-executor you have to provide Spring Boot task scheduler! (For details see https://github.com/Phactum/vanillabp-camunda7-adapter/blob/main/spring-boot/README.md#job-executor)");
        }
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new WakeupFilter(applicationEventPublisher, taskScheduler.get()));
        registrationBean.addUrlPatterns(new String[]{"/engine-rest/*"});
        registrationBean.setOrder(-1);
        return registrationBean;
    }
}

