/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.vanillabp.c7.wiring;

import io.vanillabp.spi.service.MultiInstanceElementResolver;
import io.vanillabp.spi.service.TaskEvent;
import io.vanillabp.spi.service.TaskException;
import io.vanillabp.springboot.adapter.MultiInstance;
import io.vanillabp.springboot.adapter.TaskHandlerBase;
import io.vanillabp.springboot.parameters.MethodParameter;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.model.bpmn.instance.Activity;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.MultiInstanceLoopCharacteristics;
import org.camunda.bpm.model.xml.ModelInstance;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.repository.CrudRepository;
import org.springframework.transaction.annotation.Transactional;

public class Camunda7TaskHandler
extends TaskHandlerBase
implements JavaDelegate {
    private static final Logger logger = LoggerFactory.getLogger(Camunda7TaskHandler.class);
    private final String bpmnProcessId;
    private Object result;

    public Camunda7TaskHandler(String bpmnProcessId, CrudRepository<Object, String> workflowAggregateRepository, Object bean, Method method, List<MethodParameter> parameters) {
        super(workflowAggregateRepository, bean, method, parameters);
        this.bpmnProcessId = bpmnProcessId;
    }

    protected Logger getLogger() {
        return logger;
    }

    public String getMethodName() {
        return this.method.getName();
    }

    @Transactional(noRollbackFor={BpmnError.class})
    public void execute(DelegateExecution execution) throws Exception {
        Map[] multiInstanceCache = new Map[]{null};
        try {
            logger.trace("Will handle task '{}' of workflow '{}' ('{}') by execution '{}'", new Object[]{execution.getBpmnModelElementInstance().getId(), execution.getProcessInstanceId(), this.bpmnProcessId, execution.getId()});
            super.execute(execution.getBusinessKey(), multiInstanceActivity -> {
                if (multiInstanceCache[0] == null) {
                    multiInstanceCache[0] = Camunda7TaskHandler.getMultiInstanceContext(execution);
                }
                return multiInstanceCache[0].get(multiInstanceActivity);
            }, taskParameter -> execution.getVariableLocal(taskParameter), null, () -> TaskEvent.Event.CREATED);
        }
        catch (TaskException e) {
            if (e.getErrorName() != null) {
                throw new BpmnError(e.getErrorCode(), e.getErrorName(), (Throwable)e);
            }
            throw new BpmnError(e.getErrorCode(), (Throwable)e);
        }
    }

    public Object getResult() {
        return this.result;
    }

    static Map<String, MultiInstanceElementResolver.MultiInstance<Object>> getMultiInstanceContext(DelegateExecution execution) {
        LinkedHashMap<String, MultiInstanceElementResolver.MultiInstance<Object>> result = new LinkedHashMap<String, MultiInstanceElementResolver.MultiInstance<Object>>();
        ModelInstance model = execution.getBpmnModelElementInstance().getModelInstance();
        DelegateExecution miExecution = execution;
        MultiInstanceLoopCharacteristics loopCharacteristics = null;
        while (loopCharacteristics == null) {
            ModelElementInstance bpmnElement = Camunda7TaskHandler.getCurrentElement(model, miExecution);
            if (bpmnElement instanceof Activity) {
                loopCharacteristics = (MultiInstanceLoopCharacteristics)((Activity)bpmnElement).getLoopCharacteristics();
            }
            if (loopCharacteristics == null) {
                miExecution = miExecution.getParentId() != null ? ((ExecutionEntity)miExecution).getParent() : miExecution.getSuperExecution();
            } else {
                Integer itemNo = (Integer)miExecution.getVariable("loopCounter");
                Integer totalCount = (Integer)miExecution.getVariable("nrOfInstances");
                Object currentItem = loopCharacteristics.getCamundaElementVariable() == null ? null : miExecution.getVariable(loopCharacteristics.getCamundaElementVariable());
                result.put(((BaseElement)bpmnElement).getId(), (MultiInstanceElementResolver.MultiInstance<Object>)new MultiInstance(currentItem, totalCount.intValue(), itemNo.intValue()));
            }
            if (miExecution != null || loopCharacteristics != null) continue;
            throw new RuntimeException("No multi-instance context found for element '" + execution.getBpmnModelElementInstance().getId() + "' or its parents!");
        }
        return result;
    }

    private static ModelElementInstance getCurrentElement(ModelInstance model, DelegateExecution miExecution) {
        if (miExecution.getBpmnModelElementInstance() != null) {
            return miExecution.getBpmnModelElementInstance();
        }
        String activityInstanceId = miExecution.getActivityInstanceId();
        int elementMarker = activityInstanceId.indexOf(58);
        if (elementMarker == -1) {
            return null;
        }
        return model.getModelElementById(activityInstanceId.substring(0, elementMarker));
    }
}

