/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.vanillabp.c7.wiring;

import io.vanillabp.spi.process.ProcessService;
import io.vanillabp.springboot.adapter.TaskWiringBase;
import io.vanillabp.springboot.parameters.MethodParameter;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.camunda.community.vanillabp.c7.service.Camunda7ProcessService;
import org.camunda.community.vanillabp.c7.wiring.Camunda7Connectable;
import org.camunda.community.vanillabp.c7.wiring.Camunda7TaskHandler;
import org.camunda.community.vanillabp.c7.wiring.Camunda7UserTaskEventHandler;
import org.camunda.community.vanillabp.c7.wiring.Camunda7UserTaskHandler;
import org.camunda.community.vanillabp.c7.wiring.ProcessEntityAwareExpressionManager;
import org.springframework.context.ApplicationContext;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Component;

@Component
public class Camunda7TaskWiring
extends TaskWiringBase<Camunda7Connectable, Camunda7ProcessService<?>> {
    private final ProcessEntityAwareExpressionManager processEntityAwareExpressionManager;
    private final Collection<Camunda7ProcessService<?>> connectableServices;
    private final Camunda7UserTaskEventHandler userTaskEventHandler;

    public Camunda7TaskWiring(ApplicationContext applicationContext, ProcessEntityAwareExpressionManager processEntityAwareExpressionManager, Camunda7UserTaskEventHandler userTaskEventHandler, Collection<Camunda7ProcessService<?>> connectableServices) {
        super(applicationContext);
        this.processEntityAwareExpressionManager = processEntityAwareExpressionManager;
        this.userTaskEventHandler = userTaskEventHandler;
        this.connectableServices = connectableServices;
    }

    protected void connectToBpms(Camunda7ProcessService<?> processService, Object bean, Camunda7Connectable connectable, Method method, List<MethodParameter> parameters) {
        CrudRepository<?, String> repository = processService.getWorkflowAggregateRepository();
        if (connectable.getType() == Camunda7Connectable.Type.USERTASK) {
            Camunda7UserTaskHandler taskHandler = new Camunda7UserTaskHandler(repository, bean, method, parameters);
            this.userTaskEventHandler.addTaskHandler(connectable, taskHandler);
            return;
        }
        Camunda7TaskHandler taskHandler = new Camunda7TaskHandler(connectable.getBpmnProcessId(), repository, bean, method, parameters);
        this.processEntityAwareExpressionManager.addTaskHandler(connectable, taskHandler);
    }

    protected <DE> Camunda7ProcessService<?> connectToBpms(String workflowModuleId, Class<DE> workflowAggregateClass, String bpmnProcessId) {
        Camunda7ProcessService processService = this.connectableServices.stream().filter(service -> service.getWorkflowAggregateClass().equals(workflowAggregateClass)).findFirst().orElseThrow(() -> new RuntimeException("You need to autowire '" + ProcessService.class.getName() + "<" + workflowAggregateClass.getName() + ">' in your code to be able to start workflows!"));
        processService.wire(workflowModuleId, bpmnProcessId);
        return processService;
    }

    public void validateWiring() {
        if (this.connectableServices.stream().filter(Camunda7ProcessService::testForNotYetWired).count() > 0L) {
            throw new RuntimeException("At least one ProcessService bean was not wired! See previous ERROR logs for details.");
        }
    }
}

