/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.vanillabp.c7.wiring;

import io.vanillabp.springboot.adapter.Connectable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.bpmn.behavior.DmnBusinessRuleTaskActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.listener.DelegateExpressionExecutionListener;
import org.camunda.bpm.engine.impl.bpmn.listener.ExpressionExecutionListener;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParse;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParseListener;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;
import org.camunda.bpm.engine.impl.task.TaskDefinition;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.impl.util.xml.Element;
import org.camunda.bpm.engine.impl.variable.VariableDeclaration;
import org.camunda.community.vanillabp.c7.service.Camunda7ProcessService;
import org.camunda.community.vanillabp.c7.wiring.Camunda7AdapterProperties;
import org.camunda.community.vanillabp.c7.wiring.Camunda7Connectable;
import org.camunda.community.vanillabp.c7.wiring.Camunda7TaskWiring;
import org.camunda.community.vanillabp.c7.wiring.Camunda7UserTaskEventHandler;
import org.camunda.community.vanillabp.c7.wiring.Camunda7WorkflowModuleAwareBpmnParse;
import org.springframework.util.StringUtils;

public class TaskWiringBpmnParseListener
implements BpmnParseListener {
    private static final Pattern CAMUNDA_EL_PATTERN = Pattern.compile("^[\\$\\#]\\{(.*)\\}$");
    private final Camunda7TaskWiring taskWiring;
    private final Camunda7UserTaskEventHandler userTaskEventHandler;
    private final boolean useBpmnAsyncDefinitions;
    private final List<Camunda7AdapterProperties.BpmnAsyncDefinition> bpmnAsyncDefinitions;
    private List<Camunda7Connectable> connectables = new LinkedList<Camunda7Connectable>();
    private Map<String, Camunda7Connectable> serviceTaskLikeElements = new HashMap<String, Camunda7Connectable>();

    public TaskWiringBpmnParseListener(Camunda7TaskWiring taskWiring, Camunda7UserTaskEventHandler userTaskEventHandler, boolean useBpmnAsyncDefinitions, List<Camunda7AdapterProperties.BpmnAsyncDefinition> bpmnAsyncDefinitions) {
        this.taskWiring = taskWiring;
        this.userTaskEventHandler = userTaskEventHandler;
        this.useBpmnAsyncDefinitions = useBpmnAsyncDefinitions;
        this.bpmnAsyncDefinitions = bpmnAsyncDefinitions;
    }

    public void parseProcess(Element processElement, ProcessDefinitionEntity processDefinition) {
        String workflowModuleId = Camunda7WorkflowModuleAwareBpmnParse.getWorkflowModuleId();
        String bpmnProcessId = processDefinition.getKey();
        Camunda7ProcessService processService = (Camunda7ProcessService)this.taskWiring.wireService(workflowModuleId, bpmnProcessId);
        this.connectables.forEach(connectable -> this.taskWiring.wireTask(processService, (Connectable)connectable));
        this.connectables.clear();
        this.serviceTaskLikeElements.clear();
    }

    public void parseEndEvent(Element endEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.connectEvent(endEventElement, scope, activity);
    }

    public void parseIntermediateThrowEvent(Element intermediateEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.connectEvent(intermediateEventElement, scope, activity);
    }

    public void parseUserTask(Element userTaskElement, ScopeImpl scope, ActivityImpl activity) {
        TaskDefinition taskDefinition = this.getTaskDefinition(activity);
        taskDefinition.addBuiltInTaskListener("create", (TaskListener)this.userTaskEventHandler);
        String bpmnProcessId = ((ProcessDefinitionEntity)activity.getProcessDefinition()).getKey();
        Camunda7Connectable connectable = new Camunda7Connectable(bpmnProcessId, activity.getId(), taskDefinition.getFormKey() != null ? taskDefinition.getFormKey().getExpressionText() : null, Camunda7Connectable.Type.USERTASK);
        this.connectables.add(connectable);
        this.resetAsyncForWaitstateTasks(userTaskElement, activity);
    }

    private void connectListener(Element element, ScopeImpl scope, ActivityImpl activity, Camunda7Connectable.Type type, String expression) {
        String bpmnProcessId = ((ProcessDefinitionEntity)activity.getProcessDefinition()).getKey();
        Camunda7Connectable connectable = new Camunda7Connectable(bpmnProcessId, activity.getId(), expression, type);
        this.connectables.add(connectable);
    }

    public void parseBusinessRuleTask(Element businessRuleTaskElement, ScopeImpl scope, ActivityImpl activity) {
        if (activity.getActivityBehavior() instanceof DmnBusinessRuleTaskActivityBehavior) {
            return;
        }
        this.connectTask(businessRuleTaskElement, scope, activity);
    }

    public void parseSendTask(Element sendTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.connectTask(sendTaskElement, scope, activity);
    }

    public void parseServiceTask(Element serviceTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.connectTask(serviceTaskElement, scope, activity);
    }

    private void connectTask(Element element, ScopeImpl scope, ActivityImpl activity) {
        if (!this.connectTaskLike(element, scope, activity)) {
            throw new RuntimeException("Missing implemenation 'delegate-expression' or 'external-task topic' on element '" + activity.getId() + "'");
        }
        this.resetAsyncForNonWaitstateTasks(element, activity);
    }

    private boolean connectTaskLike(Element element, ScopeImpl scope, ActivityImpl activity) {
        Camunda7Connectable connectable;
        String bpmnProcessId = ((ProcessDefinitionEntity)activity.getProcessDefinition()).getKey();
        String delegateExpression = element.attributeNS(BpmnParse.CAMUNDA_BPMN_EXTENSIONS_NS, "delegateExpression");
        String expression = element.attributeNS(BpmnParse.CAMUNDA_BPMN_EXTENSIONS_NS, "expression");
        String topic = element.attributeNS(BpmnParse.CAMUNDA_BPMN_EXTENSIONS_NS, "topic");
        if (StringUtil.hasText((String)delegateExpression)) {
            String unwrappedDelegateExpression = this.unwrapExpression(activity, delegateExpression);
            connectable = new Camunda7Connectable(bpmnProcessId, activity.getId(), unwrappedDelegateExpression, Camunda7Connectable.Type.DELEGATE_EXPRESSION);
        } else if (StringUtil.hasText((String)expression)) {
            String unwrappedExpression = this.unwrapExpression(activity, expression);
            connectable = new Camunda7Connectable(bpmnProcessId, activity.getId(), unwrappedExpression, Camunda7Connectable.Type.EXPRESSION);
        } else if (StringUtil.hasText((String)topic)) {
            connectable = new Camunda7Connectable(bpmnProcessId, activity.getId(), topic, Camunda7Connectable.Type.EXTERNAL_TASK);
        } else {
            return false;
        }
        this.connectables.add(connectable);
        return true;
    }

    private void connectEvent(Element eventElement, ScopeImpl scope, ActivityImpl activity) {
        boolean connectedByImplementation;
        Element messageEventDefinition = eventElement.element("messageEventDefinition");
        if (messageEventDefinition != null && (connectedByImplementation = this.connectTaskLike(messageEventDefinition, scope, activity))) {
            this.resetAsyncForNonWaitstateTasks(eventElement, activity);
            return;
        }
        String unsupportedListeners = activity.getListeners().values().stream().flatMap(Collection::stream).filter(l -> {
            if (l instanceof ExpressionExecutionListener) {
                String expression = this.unwrapExpression(activity, ((ExpressionExecutionListener)l).getExpressionText());
                this.connectListener(eventElement, scope, activity, Camunda7Connectable.Type.EXPRESSION, expression);
                return false;
            }
            return true;
        }).filter(l -> {
            if (l instanceof DelegateExpressionExecutionListener) {
                String expression = this.unwrapExpression(activity, ((DelegateExpressionExecutionListener)l).getExpressionText());
                this.connectListener(eventElement, scope, activity, Camunda7Connectable.Type.DELEGATE_EXPRESSION, expression);
                return false;
            }
            return true;
        }).map(l -> l.toString()).collect(Collectors.joining(", "));
        if (StringUtils.hasText((String)unsupportedListeners)) {
            throw new RuntimeException("Unsupported listeners at '" + activity.getId() + "': " + unsupportedListeners);
        }
    }

    private String unwrapExpression(ActivityImpl activity, String delegateExpression) {
        Matcher expressionWrapperMatcher = CAMUNDA_EL_PATTERN.matcher(delegateExpression);
        if (!expressionWrapperMatcher.find()) {
            throw new RuntimeException("'delegate-expression' of element '" + activity.getId() + "' not uses pattern ${...} or #{...}: '" + delegateExpression + "'");
        }
        return expressionWrapperMatcher.group(1);
    }

    private TaskDefinition getTaskDefinition(ActivityImpl activity) {
        UserTaskActivityBehavior activityBehavior = (UserTaskActivityBehavior)activity.getActivityBehavior();
        return activityBehavior.getTaskDefinition();
    }

    private void removeAsyncBeforeAndAsyncAfter(Element element, ActivityImpl activity) {
        this.resetAsyncBeforeAndAsyncAfter(element, activity, Async.DONT_SET);
    }

    private void resetAsyncForWaitstateTasks(Element element, ActivityImpl activity) {
        this.resetAsyncBeforeAndAsyncAfter(element, activity, Async.SET_ASYNC_AFTER_ONLY);
    }

    private void resetAsyncForNonWaitstateTasks(Element element, ActivityImpl activity) {
        this.resetAsyncBeforeAndAsyncAfter(element, activity, Async.SET_ASYNC_BEFORE_AND_AFTER);
    }

    private void resetAsyncBeforeAndAsyncAfter(Element element, ActivityImpl activity, Async mode) {
        if (this.useBpmnAsyncDefinitions) {
            return;
        }
        String workflowModuleId = Camunda7WorkflowModuleAwareBpmnParse.getWorkflowModuleId();
        String bpmnProcessId = ((ProcessDefinitionEntity)activity.getProcessDefinition()).getKey();
        if (this.bpmnAsyncDefinitions.stream().filter(d -> d.getWorkflowModuleId().equals(workflowModuleId)).filter(d -> d.getBpmnProcessId().equals(bpmnProcessId)).findFirst().isPresent()) {
            return;
        }
        activity.setAsyncAfter(false);
        activity.setAsyncBefore(false);
        if (mode == Async.SET_ASYNC_BEFORE_AND_AFTER || mode == Async.SET_ASYNC_BEFORE_ONLY) {
            activity.setAsyncBefore(true, true);
        }
        if (mode == Async.SET_ASYNC_BEFORE_AND_AFTER || mode == Async.SET_ASYNC_AFTER_ONLY) {
            activity.setAsyncAfter(true, true);
        }
    }

    public void parseStartEvent(Element element, ScopeImpl scope, ActivityImpl activity) {
        this.resetAsyncBeforeAndAsyncAfter(element, activity, Async.SET_ASYNC_BEFORE_ONLY);
    }

    public void parseExclusiveGateway(Element element, ScopeImpl scope, ActivityImpl activity) {
        this.removeAsyncBeforeAndAsyncAfter(element, activity);
    }

    public void parseInclusiveGateway(Element element, ScopeImpl scope, ActivityImpl activity) {
        this.removeAsyncBeforeAndAsyncAfter(element, activity);
    }

    public void parseParallelGateway(Element element, ScopeImpl scope, ActivityImpl activity) {
        this.removeAsyncBeforeAndAsyncAfter(element, activity);
    }

    public void parseScriptTask(Element element, ScopeImpl scope, ActivityImpl activity) {
        this.resetAsyncForNonWaitstateTasks(element, activity);
    }

    public void parseTask(Element element, ScopeImpl scope, ActivityImpl activity) {
        this.removeAsyncBeforeAndAsyncAfter(element, activity);
    }

    public void parseManualTask(Element element, ScopeImpl scope, ActivityImpl activity) {
        this.removeAsyncBeforeAndAsyncAfter(element, activity);
    }

    public void parseBoundaryTimerEventDefinition(Element element, boolean interrupting, ActivityImpl activity) {
        this.removeAsyncBeforeAndAsyncAfter(element, activity);
    }

    public void parseBoundaryErrorEventDefinition(Element element, boolean interrupting, ActivityImpl activity, ActivityImpl nestedErrorEventActivity) {
        this.resetAsyncForWaitstateTasks(element, activity);
    }

    public void parseSubProcess(Element element, ScopeImpl scope, ActivityImpl activity) {
        this.removeAsyncBeforeAndAsyncAfter(element, activity);
    }

    public void parseCallActivity(Element element, ScopeImpl scope, ActivityImpl activity) {
        this.removeAsyncBeforeAndAsyncAfter(element, activity);
    }

    public void parseProperty(Element element, VariableDeclaration variableDeclaration, ActivityImpl activity) {
        this.removeAsyncBeforeAndAsyncAfter(element, activity);
    }

    public void parseSequenceFlow(Element sequenceFlowElement, ScopeImpl scopeElement, TransitionImpl transition) {
    }

    public void parseMultiInstanceLoopCharacteristics(Element element, Element multiInstanceLoopCharacteristicsElement, ActivityImpl activity) {
        this.removeAsyncBeforeAndAsyncAfter(element, activity);
    }

    public void parseIntermediateTimerEventDefinition(Element element, ActivityImpl activity) {
        this.removeAsyncBeforeAndAsyncAfter(element, activity);
    }

    public void parseRootElement(Element rootElement, List<ProcessDefinitionEntity> processDefinitions) {
    }

    public void parseReceiveTask(Element element, ScopeImpl scope, ActivityImpl activity) {
        this.resetAsyncForWaitstateTasks(element, activity);
    }

    public void parseIntermediateSignalCatchEventDefinition(Element element, ActivityImpl activity) {
        this.resetAsyncForWaitstateTasks(element, activity);
    }

    public void parseBoundarySignalEventDefinition(Element element, boolean interrupting, ActivityImpl activity) {
        this.resetAsyncForWaitstateTasks(element, activity);
    }

    public void parseEventBasedGateway(Element element, ScopeImpl scope, ActivityImpl activity) {
        this.removeAsyncBeforeAndAsyncAfter(element, activity);
    }

    public void parseTransaction(Element element, ScopeImpl scope, ActivityImpl activity) {
        this.removeAsyncBeforeAndAsyncAfter(element, activity);
    }

    public void parseCompensateEventDefinition(Element element, ActivityImpl activity) {
        this.removeAsyncBeforeAndAsyncAfter(element, activity);
    }

    public void parseIntermediateCatchEvent(Element element, ScopeImpl scope, ActivityImpl activity) {
        this.removeAsyncBeforeAndAsyncAfter(element, activity);
    }

    public void parseBoundaryEvent(Element element, ScopeImpl scope, ActivityImpl activity) {
        this.removeAsyncBeforeAndAsyncAfter(element, activity);
    }

    public void parseIntermediateMessageCatchEventDefinition(Element element, ActivityImpl activity) {
        this.resetAsyncForWaitstateTasks(element, activity);
    }

    public void parseBoundaryMessageEventDefinition(Element element, boolean interrupting, ActivityImpl activity) {
        this.resetAsyncForWaitstateTasks(element, activity);
    }

    public void parseBoundaryEscalationEventDefinition(Element element, boolean interrupting, ActivityImpl activity) {
        this.removeAsyncBeforeAndAsyncAfter(element, activity);
    }

    public void parseBoundaryConditionalEventDefinition(Element element, boolean interrupting, ActivityImpl activity) {
        this.removeAsyncBeforeAndAsyncAfter(element, activity);
    }

    public void parseIntermediateConditionalEventDefinition(Element element, ActivityImpl activity) {
        this.resetAsyncForWaitstateTasks(element, activity);
    }

    public void parseConditionalStartEventForEventSubprocess(Element element, ActivityImpl activity, boolean interrupting) {
        this.removeAsyncBeforeAndAsyncAfter(element, activity);
    }

    static enum Async {
        DONT_SET,
        SET_ASYNC_BEFORE_ONLY,
        SET_ASYNC_AFTER_ONLY,
        SET_ASYNC_BEFORE_AND_AFTER;

    }
}

