/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda7.deployment;

import io.vanillabp.camunda7.wiring.Camunda7TaskWiring;
import io.vanillabp.springboot.adapter.ModuleAwareBpmnDeployment;
import java.io.InputStream;
import javax.annotation.PostConstruct;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.spring.application.SpringProcessApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class Camunda7DeploymentAdapter
extends ModuleAwareBpmnDeployment {
    private static final Logger logger = LoggerFactory.getLogger(Camunda7DeploymentAdapter.class);
    private final ProcessEngine processEngine;
    private final SpringProcessApplication processApplication;
    private final Camunda7TaskWiring taskWiring;

    public Camunda7DeploymentAdapter(SpringProcessApplication processApplication, Camunda7TaskWiring taskWiring, ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.processApplication = processApplication;
        this.taskWiring = taskWiring;
    }

    protected Logger getLogger() {
        return logger;
    }

    @PostConstruct
    public void deployAllWorkflowModules() {
        super.deployAllWorkflowModules();
        this.taskWiring.validateWiring();
    }

    protected void doDeployment(String workflowModuleId, Resource[] bpmns, Resource[] dmns, Resource[] cmms) throws Exception {
        InputStream inputStream;
        DeploymentBuilder deploymentBuilder = this.processEngine.getRepositoryService().createDeployment(this.processApplication.getReference()).resumePreviousVersions().resumePreviousVersionsBy("deployment-name").enableDuplicateFiltering(true).source(this.applicationName).tenantId(workflowModuleId).name(workflowModuleId);
        boolean hasDeployables = false;
        for (Resource resource : bpmns) {
            inputStream = resource.getInputStream();
            try {
                deploymentBuilder.addInputStream(resource.getFilename(), inputStream);
                hasDeployables = true;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        for (Resource resource : cmms) {
            inputStream = resource.getInputStream();
            try {
                deploymentBuilder.addInputStream(resource.getFilename(), inputStream);
                hasDeployables = true;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        for (Resource resource : dmns) {
            inputStream = resource.getInputStream();
            try {
                deploymentBuilder.addInputStream(resource.getFilename(), inputStream);
                hasDeployables = true;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        if (hasDeployables) {
            deploymentBuilder.deploy();
        }
        this.processEngine.getRepositoryService().createProcessDefinitionQuery().tenantIdIn(new String[]{workflowModuleId}).list().forEach(definition -> this.processEngine.getRepositoryService().getProcessModel(definition.getId()));
    }
}

