/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda7.wiring;

import io.vanillabp.camunda7.service.Camunda7ProcessService;
import io.vanillabp.camunda7.utils.CaseUtils;
import io.vanillabp.camunda7.wiring.Camunda7Connectable;
import io.vanillabp.camunda7.wiring.Camunda7TaskHandler;
import java.beans.FeatureDescriptor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.impl.javax.el.ELContext;
import org.camunda.bpm.engine.impl.javax.el.ELResolver;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.model.bpmn.instance.FlowElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessEntityELResolver
extends ELResolver {
    private static final Logger logger = LoggerFactory.getLogger(ProcessEntityELResolver.class);
    private final Map<Camunda7Connectable, Camunda7TaskHandler> taskHandlers = new HashMap<Camunda7Connectable, Camunda7TaskHandler>();
    private final Map<String, Camunda7ProcessService<?>> processServices;

    public ProcessEntityELResolver(Collection<Camunda7ProcessService<?>> connectableServices) {
        this.processServices = connectableServices.stream().collect(Collectors.toMap(Camunda7ProcessService::getBpmnProcessId, s -> s));
    }

    public void addTaskHandler(Camunda7Connectable connectable, Camunda7TaskHandler taskHandler) {
        this.taskHandlers.put(connectable, taskHandler);
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return Object.class;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        return Object.class;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (base != null) {
            return null;
        }
        ExecutionEntity execution = (ExecutionEntity)context.getELResolver().getValue(context, null, (Object)"execution");
        String bpmnProcessId = execution.getProcessDefinition().getKey();
        Object result = this.taskHandlers.entrySet().stream().filter(entry -> {
            Camunda7Connectable connectable = (Camunda7Connectable)entry.getKey();
            if (!connectable.getBpmnProcessId().equals(bpmnProcessId)) {
                return false;
            }
            FlowElement element = execution.getBpmnModelElementInstance();
            if (element == null) {
                return false;
            }
            return connectable.applies(element.getId(), property.toString());
        }).findFirst().map(handler -> this.executeHandler(execution, (Camunda7Connectable)handler.getKey(), (Camunda7TaskHandler)((Object)((Object)handler.getValue())))).orElseGet(() -> {
            Camunda7ProcessService<?> processService = this.processServices.get(bpmnProcessId);
            if (processService == null) {
                return null;
            }
            Optional workflowAggregateFound = processService.getWorkflowAggregateRepository().findById((Object)execution.getBusinessKey());
            if (workflowAggregateFound.isEmpty()) {
                return null;
            }
            Object workflowAggregate = workflowAggregateFound.get();
            Class<?> workflowAggregateClass = processService.getWorkflowAggregateClass();
            String getterName = "get" + CaseUtils.firstCharacterToUpperCase(property.toString());
            try {
                return workflowAggregateClass.getMethod(getterName, new Class[0]).invoke(workflowAggregate, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception e) {
                logger.warn("Could not access '{}#{}'", new Object[]{workflowAggregateClass.getName(), getterName, e});
                return null;
            }
            String isGetterName = "is" + CaseUtils.firstCharacterToUpperCase(property.toString());
            try {
                return workflowAggregateClass.getMethod(isGetterName, new Class[0]).invoke(workflowAggregate, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception e) {
                logger.warn("Could not access '{}#{}'", new Object[]{workflowAggregateClass.getName(), isGetterName, e});
                return null;
            }
            try {
                Field field = workflowAggregateClass.getDeclaredField(property.toString());
                field.setAccessible(true);
                return field.get(workflowAggregate);
            }
            catch (NoSuchFieldException field) {
            }
            catch (Exception e) {
                logger.warn("Could not access property '{}' in class '{}'", new Object[]{property.toString(), workflowAggregateClass.getName(), e});
                return null;
            }
            return null;
        });
        return result;
    }

    private Object executeHandler(ExecutionEntity execution, Camunda7Connectable connectable, Camunda7TaskHandler taskHandler) {
        if (connectable.getType() == Camunda7Connectable.Type.EXPRESSION) {
            try {
                taskHandler.execute((DelegateExecution)execution);
                return taskHandler.getResult();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not execute handler", e);
            }
        }
        if (connectable.getType() == Camunda7Connectable.Type.DELEGATE_EXPRESSION) {
            return taskHandler;
        }
        return null;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        return true;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (base == null && this.getValue(context, null, property) != null) {
            throw new ProcessEngineException("Cannot set value of '" + property + "', it resolves to a process entity bound to the process instance.");
        }
    }
}

