/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda7.jobexecutor;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.jobexecutor.BackoffJobAcquisitionStrategy;
import org.camunda.bpm.engine.impl.jobexecutor.JobAcquisitionContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.util.ClassLoaderUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WakeupBackoffJobAcquisitionStrategy
extends BackoffJobAcquisitionStrategy {
    private static final Logger logger = LoggerFactory.getLogger(WakeupBackoffJobAcquisitionStrategy.class);
    public static long DEFAULT_EXECUTION_SATURATION_WAIT_TIME = 100L;
    private final JobExecutor jobExecutor;
    private long waitTime;

    public WakeupBackoffJobAcquisitionStrategy(JobExecutor jobExecutor) {
        super(jobExecutor);
        this.jobExecutor = jobExecutor;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconfigure(JobAcquisitionContext context) {
        super.reconfigure(context);
        this.waitTime = super.getWaitTime();
        if (this.waitTime == 0L || this.waitTime != this.maxIdleWaitTime && this.waitTime != this.maxBackoffWaitTime) {
            return;
        }
        Date now = new Date();
        Date earliestDueDate = new Date(Long.MAX_VALUE);
        Iterator engineIterator = this.jobExecutor.engineIterator();
        ClassLoader classLoaderBeforeExecution = ClassLoaderUtil.switchToProcessEngineClassloader();
        try {
            while (engineIterator.hasNext()) {
                List jobs;
                ProcessEngineImpl currentProcessEngine = (ProcessEngineImpl)engineIterator.next();
                if (!this.jobExecutor.hasRegisteredEngine(currentProcessEngine) || (jobs = ((JobQuery)currentProcessEngine.getManagementService().createJobQuery().active().withRetriesLeft().duedateHigherThan(now).orderByJobDuedate().asc()).list()).isEmpty()) continue;
                Job earliestJob = (Job)jobs.get(0);
                if (earliestJob.getDuedate() == null) {
                    earliestDueDate = now;
                    continue;
                }
                if (!earliestJob.getDuedate().before(earliestDueDate)) continue;
                earliestDueDate = earliestJob.getDuedate();
            }
            this.waitTime = earliestDueDate.getTime() - now.getTime();
            if (earliestDueDate.getTime() == Long.MAX_VALUE) {
                logger.debug("No Job found having due-date set, JobExecutor will wait until external interaction");
            } else {
                logger.debug("Job with due-date set found, will wait until {}", (Object)earliestDueDate);
            }
        }
        catch (Exception e) {
            logger.warn("Error on trying to figure out if next job is timer-based", (Throwable)e);
        }
        finally {
            ClassLoaderUtil.setContextClassloader((ClassLoader)classLoaderBeforeExecution);
        }
    }
}

