/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda7;

import io.vanillabp.camunda7.deployment.Camunda7DeploymentAdapter;
import io.vanillabp.camunda7.service.Camunda7ProcessService;
import io.vanillabp.camunda7.wiring.Camunda7AdapterProperties;
import io.vanillabp.camunda7.wiring.Camunda7TaskWiring;
import io.vanillabp.camunda7.wiring.Camunda7TaskWiringPlugin;
import io.vanillabp.camunda7.wiring.Camunda7UserTaskEventHandler;
import io.vanillabp.camunda7.wiring.ProcessEntityAwareExpressionManager;
import io.vanillabp.camunda7.wiring.TaskWiringBpmnParseListener;
import io.vanillabp.springboot.adapter.AdapterConfigurationBase;
import io.vanillabp.springboot.adapter.SpringDataUtil;
import io.vanillabp.springboot.adapter.VanillaBpProperties;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.spring.application.SpringProcessApplication;
import org.camunda.bpm.spring.boot.starter.CamundaBpmAutoConfiguration;
import org.camunda.bpm.spring.boot.starter.annotation.EnableProcessApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigurationPackage;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.repository.CrudRepository;

@AutoConfigurationPackage(basePackageClasses={Camunda7AdapterConfiguration.class})
@AutoConfigureBefore(value={CamundaBpmAutoConfiguration.class})
@EnableProcessApplication(value="org.camunda.bpm.spring.boot.starter.SpringBootProcessApplication")
public class Camunda7AdapterConfiguration
extends AdapterConfigurationBase<Camunda7ProcessService<?>> {
    private static final Logger logger = LoggerFactory.getLogger(Camunda7AdapterConfiguration.class);
    public static final String ADAPTER_ID = "camunda7";
    @Value(value="${workerId}")
    private String workerId;
    @Autowired
    private SpringDataUtil springDataUtil;
    @Autowired
    private ApplicationContext applicationContext;
    @Lazy
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @PostConstruct
    public void init() {
        logger.debug("Will use SpringDataUtil class '{}'", (Object)AopProxyUtils.ultimateTargetClass((Object)this.springDataUtil));
    }

    public String getAdapterId() {
        return ADAPTER_ID;
    }

    @Bean
    public Camunda7AdapterProperties camunda7AdapterProperties() {
        return new Camunda7AdapterProperties();
    }

    @Bean
    public Camunda7DeploymentAdapter camunda7DeploymentAdapter(VanillaBpProperties properties, SpringProcessApplication processApplication, ProcessEngine processEngine, Camunda7TaskWiring taskWiring) {
        return new Camunda7DeploymentAdapter(properties, processApplication, taskWiring, processEngine);
    }

    @Bean
    public Camunda7UserTaskEventHandler userTaskEventHandler() {
        return new Camunda7UserTaskEventHandler();
    }

    @Bean
    public Camunda7TaskWiring taskWiring(ProcessEntityAwareExpressionManager processEntityAwareExpressionManager, Camunda7UserTaskEventHandler userTaskEventHandler) {
        return new Camunda7TaskWiring(this.applicationContext, processEntityAwareExpressionManager, userTaskEventHandler, this.getConnectableServices());
    }

    @Bean
    public TaskWiringBpmnParseListener taskWiringBpmnParseListener(Camunda7TaskWiring taskWiring, Camunda7UserTaskEventHandler userTaskEventHandler, Camunda7AdapterProperties properties) {
        return new TaskWiringBpmnParseListener(taskWiring, userTaskEventHandler, properties.isUseBpmnAsyncDefinitions(), properties.getBpmnAsyncDefinitions());
    }

    @Bean
    public ProcessEntityAwareExpressionManager processEntityAwareExpressionManager() {
        return new ProcessEntityAwareExpressionManager(this.applicationContext, this.getConnectableServices());
    }

    @Bean
    public Camunda7TaskWiringPlugin taskWiringCamundaPlugin(ProcessEntityAwareExpressionManager processEntityAwareExpressionManager, TaskWiringBpmnParseListener taskWiringBpmnParseListener) {
        return new Camunda7TaskWiringPlugin(processEntityAwareExpressionManager, taskWiringBpmnParseListener);
    }

    public <DE> Camunda7ProcessService<?> newProcessServiceImplementation(SpringDataUtil springDataUtil, Class<DE> workflowAggregateClass, Class<?> workflowAggregateIdClass, CrudRepository<DE, Object> workflowAggregateRepository) {
        Function<String, Object> parseWorkflowAggregateIdFromBusinessKey;
        if (String.class.isAssignableFrom(workflowAggregateIdClass)) {
            parseWorkflowAggregateIdFromBusinessKey = businessKey -> businessKey;
        } else if (Integer.TYPE.isAssignableFrom(workflowAggregateIdClass)) {
            parseWorkflowAggregateIdFromBusinessKey = businessKey -> Integer.valueOf(businessKey);
        } else if (Long.TYPE.isAssignableFrom(workflowAggregateIdClass)) {
            parseWorkflowAggregateIdFromBusinessKey = businessKey -> Long.valueOf(businessKey);
        } else if (Float.TYPE.isAssignableFrom(workflowAggregateIdClass)) {
            parseWorkflowAggregateIdFromBusinessKey = businessKey -> Float.valueOf(businessKey);
        } else if (Double.TYPE.isAssignableFrom(workflowAggregateIdClass)) {
            parseWorkflowAggregateIdFromBusinessKey = businessKey -> Double.valueOf(businessKey);
        } else if (Byte.TYPE.isAssignableFrom(workflowAggregateIdClass)) {
            parseWorkflowAggregateIdFromBusinessKey = businessKey -> Byte.valueOf(businessKey);
        } else if (BigInteger.class.isAssignableFrom(workflowAggregateIdClass)) {
            parseWorkflowAggregateIdFromBusinessKey = businessKey -> new BigInteger((String)businessKey);
        } else {
            try {
                Method valueOfMethod = workflowAggregateIdClass.getMethod("valueOf", String.class);
                parseWorkflowAggregateIdFromBusinessKey = businessKey -> {
                    try {
                        return valueOfMethod.invoke(null, businessKey);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not determine the workflow's aggregate id!", e);
                    }
                };
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("The id's class '%s' of the workflow-aggregate '%s' does not implement a method 'public static %s valueOf(String businessKey)'! Please add this method required by VanillaBP 'camunda7' adapter.", workflowAggregateIdClass.getName(), workflowAggregateClass.getName(), workflowAggregateIdClass.getSimpleName()));
            }
        }
        Camunda7ProcessService<Object> result = new Camunda7ProcessService<Object>(this.applicationEventPublisher, this.processEngine, workflowAggregate -> !springDataUtil.isPersistedEntity(workflowAggregateClass, workflowAggregate), workflowAggregate -> springDataUtil.getId(workflowAggregate), workflowAggregateRepository, workflowAggregateClass, parseWorkflowAggregateIdFromBusinessKey);
        this.putConnectableService(workflowAggregateClass, result);
        return result;
    }
}

