/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda7.deployment;

import io.vanillabp.camunda7.wiring.Camunda7TaskWiring;
import io.vanillabp.camunda7.wiring.TaskWiringBpmnParseListener;
import io.vanillabp.springboot.adapter.ModuleAwareBpmnDeployment;
import io.vanillabp.springboot.adapter.VanillaBpProperties;
import java.io.InputStream;
import javax.annotation.PostConstruct;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.spring.application.SpringProcessApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class Camunda7DeploymentAdapter
extends ModuleAwareBpmnDeployment {
    private static final Logger logger = LoggerFactory.getLogger(Camunda7DeploymentAdapter.class);
    private final ProcessEngine processEngine;
    private final SpringProcessApplication processApplication;
    private final Camunda7TaskWiring taskWiring;

    public Camunda7DeploymentAdapter(VanillaBpProperties properties, SpringProcessApplication processApplication, Camunda7TaskWiring taskWiring, ProcessEngine processEngine) {
        super(properties);
        this.processEngine = processEngine;
        this.processApplication = processApplication;
        this.taskWiring = taskWiring;
    }

    protected Logger getLogger() {
        return logger;
    }

    protected String getAdapterId() {
        return "camunda7";
    }

    @PostConstruct
    public void deployAllWorkflowModules() {
        super.deployAllWorkflowModules();
        this.taskWiring.validateWiring();
    }

    protected void doDeployment(String workflowModuleId, String workflowModuleName, Resource[] bpmns, Resource[] dmns, Resource[] cmms) throws Exception {
        InputStream inputStream;
        DeploymentBuilder deploymentBuilder = this.processEngine.getRepositoryService().createDeployment(this.processApplication.getReference()).resumePreviousVersions().resumePreviousVersionsBy("deployment-name").enableDuplicateFiltering(true).source(this.applicationName).tenantId(workflowModuleName).name(workflowModuleName);
        boolean hasDeployables = false;
        for (Resource resource : bpmns) {
            inputStream = resource.getInputStream();
            try {
                deploymentBuilder.addInputStream(resource.getFilename(), inputStream);
                hasDeployables = true;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        for (Resource resource : cmms) {
            inputStream = resource.getInputStream();
            try {
                deploymentBuilder.addInputStream(resource.getFilename(), inputStream);
                hasDeployables = true;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        for (Resource resource : dmns) {
            inputStream = resource.getInputStream();
            try {
                deploymentBuilder.addInputStream(resource.getFilename(), inputStream);
                hasDeployables = true;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        String deploymentId = hasDeployables ? deploymentBuilder.deployWithResult().getId() : "";
        this.processEngine.getRepositoryService().createProcessDefinitionQuery().tenantIdIn(new String[]{workflowModuleName}).list().stream().forEach(definition -> {
            try {
                TaskWiringBpmnParseListener.setOldVersionBpmn(!definition.getDeploymentId().equals(deploymentId));
                this.processEngine.getRepositoryService().getProcessModel(definition.getId());
            }
            finally {
                TaskWiringBpmnParseListener.setOldVersionBpmn(false);
            }
        });
    }
}

