/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda7.service;

import io.vanillabp.camunda7.service.WakupJobExecutorNotification;
import io.vanillabp.springboot.adapter.AdapterAwareProcessService;
import io.vanillabp.springboot.adapter.ProcessServiceImplementation;
import java.util.Collection;
import java.util.function.Function;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ExecutionQuery;
import org.camunda.bpm.engine.runtime.MessageCorrelationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.repository.CrudRepository;

public class Camunda7ProcessService<DE>
implements ProcessServiceImplementation<DE> {
    private static final Logger logger = LoggerFactory.getLogger(Camunda7ProcessService.class);
    private final ApplicationEventPublisher applicationEventPublisher;
    private final ProcessEngine processEngine;
    private final CrudRepository<DE, Object> workflowAggregateRepository;
    private final Class<DE> workflowAggregateClass;
    private final Function<DE, ?> getWorkflowAggregateId;
    private final Function<DE, Boolean> isNewEntity;
    private final Function<String, Object> parseWorkflowAggregateIdFromBusinessKey;
    private AdapterAwareProcessService<DE> parent;

    public Camunda7ProcessService(ApplicationEventPublisher applicationEventPublisher, ProcessEngine processEngine, Function<DE, Boolean> isNewEntity, Function<DE, ?> getWorkflowAggregateId, CrudRepository<DE, Object> workflowAggregateRepository, Class<DE> workflowAggregateClass, Function<String, Object> parseWorkflowAggregateIdFromBusinessKey) {
        this.applicationEventPublisher = applicationEventPublisher;
        this.processEngine = processEngine;
        this.workflowAggregateRepository = workflowAggregateRepository;
        this.workflowAggregateClass = workflowAggregateClass;
        this.isNewEntity = isNewEntity;
        this.getWorkflowAggregateId = getWorkflowAggregateId;
        this.parseWorkflowAggregateIdFromBusinessKey = parseWorkflowAggregateIdFromBusinessKey;
    }

    public void setParent(AdapterAwareProcessService<DE> parent) {
        this.parent = parent;
    }

    public Collection<String> getBpmnProcessIds() {
        return this.parent.getBpmnProcessIds();
    }

    public void wire(String workflowModuleId, String bpmnProcessId, boolean isPrimary, Collection<String> messageBasedStartEventsMessageNames, Collection<String> signalBasedStartEventsSignalNames) {
        if (this.parent == null) {
            throw new RuntimeException("Not yet wired! If this occurs Spring Boot dependency of either VanillaBP Spring Boot support or Camunda7 adapter was changed introducing this lack of wiring. Please report a Github issue!");
        }
        this.parent.wire("camunda7", workflowModuleId, bpmnProcessId, isPrimary, messageBasedStartEventsMessageNames, signalBasedStartEventsSignalNames);
    }

    public boolean testForNotYetWired() {
        if (this.parent.getPrimaryBpmnProcessId() == null) {
            logger.error("The bean ProcessService<{}> was not wired to a BPMN process! It is likely that the BPMN is not part of the classpath.", (Object)this.workflowAggregateClass.getName());
            return true;
        }
        return false;
    }

    public Class<DE> getWorkflowAggregateClass() {
        return this.workflowAggregateClass;
    }

    public CrudRepository<DE, Object> getWorkflowAggregateRepository() {
        return this.workflowAggregateRepository;
    }

    public Object getWorkflowAggregateIdFromBusinessKey(String businessKey) {
        return this.parseWorkflowAggregateIdFromBusinessKey.apply(businessKey);
    }

    public DE startWorkflow(DE workflowAggregate) throws Exception {
        Object attachedAggregate = this.workflowAggregateRepository.save(workflowAggregate);
        String id = this.getWorkflowAggregateId.apply(attachedAggregate).toString();
        this.wakeupJobExecutorOnActivity();
        this.processEngine.getRuntimeService().createProcessInstanceByKey(this.parent.getPrimaryBpmnProcessId()).businessKey(id).processDefinitionTenantId(this.parent.getWorkflowModuleId()).execute();
        return (DE)this.workflowAggregateRepository.save(attachedAggregate);
    }

    public DE correlateMessage(DE workflowAggregate, String messageName) {
        return this.correlateMessage(workflowAggregate, messageName, null, null);
    }

    public DE correlateMessage(DE workflowAggregate, Object message) {
        return this.correlateMessage(workflowAggregate, message.getClass().getSimpleName());
    }

    public DE correlateMessage(DE workflowAggregate, String messageName, String correlationId) {
        String correlationIdLocalVariableName = this.parent.getPrimaryBpmnProcessId() + "-" + messageName;
        return this.correlateMessage(workflowAggregate, messageName, correlationIdLocalVariableName, correlationId);
    }

    public DE correlateMessage(DE workflowAggregate, Object message, String correlationId) {
        return this.correlateMessage(workflowAggregate, message.getClass().getSimpleName(), correlationId);
    }

    private DE correlateMessage(DE workflowAggregate, String messageName, String correlationIdLocalVariableName, String correlationId) {
        boolean hasMessageCorrelation;
        Boolean isNewEntity = this.isNewEntity.apply(workflowAggregate);
        Object attachedAggregate = this.workflowAggregateRepository.save(workflowAggregate);
        Object id = this.getWorkflowAggregateId.apply(attachedAggregate);
        MessageCorrelationBuilder correlation = this.processEngine.getRuntimeService().createMessageCorrelation(messageName).processInstanceBusinessKey(id.toString());
        if (correlationIdLocalVariableName != null) {
            correlation.localVariableEquals(correlationIdLocalVariableName, (Object)correlationId);
        }
        this.wakeupJobExecutorOnActivity();
        if (isNewEntity.booleanValue()) {
            ProcessInstance result = correlation.correlateStartMessage();
            logger.trace("Started process '{}#{}' by message-correlation '{}' (tenant: {})", new Object[]{this.parent.getPrimaryBpmnProcessId(), result.getProcessInstanceId(), messageName, result.getTenantId()});
            return (DE)attachedAggregate;
        }
        ExecutionQuery correlationExecutions = this.processEngine.getRuntimeService().createExecutionQuery().messageEventSubscriptionName(messageName).processInstanceBusinessKey(id.toString()).active();
        if (correlationIdLocalVariableName != null) {
            correlationExecutions.variableValueEquals(correlationIdLocalVariableName, (Object)correlationId);
        }
        boolean bl = hasMessageCorrelation = correlationExecutions.count() == 1L;
        if (!hasMessageCorrelation) {
            logger.trace("Message '{}' of process having bpmn-process-id '{}' could not be correlated using correlation-id '{}' for workflow aggregate '{}'!", new Object[]{messageName, this.parent.getPrimaryBpmnProcessId(), correlationId, id});
            return (DE)attachedAggregate;
        }
        Execution result = correlation.correlateWithResult().getExecution();
        logger.trace("Correlated message '{}' using correlation-id '{}' for process '{}#{}' and execution '{}' (tenant: {})", new Object[]{messageName, correlationId, this.parent.getPrimaryBpmnProcessId(), result.getProcessInstanceId(), result.getId(), result.getTenantId()});
        return (DE)attachedAggregate;
    }

    public DE completeUserTask(DE workflowAggregate, String taskId) {
        Object attachedAggregate = this.workflowAggregateRepository.save(workflowAggregate);
        Object id = this.getWorkflowAggregateId.apply(workflowAggregate);
        Task task = (Task)this.processEngine.getTaskService().createTaskQuery().processInstanceBusinessKey(id.toString()).taskId(taskId).singleResult();
        if (task == null) {
            throw new NullValueException("Task '" + taskId + "' not found!");
        }
        this.wakeupJobExecutorOnActivity();
        this.processEngine.getTaskService().complete(taskId);
        return (DE)attachedAggregate;
    }

    public DE completeTask(DE workflowAggregate, String taskId) {
        throw new UnsupportedOperationException();
    }

    public DE cancelTask(DE workflowAggregate, String taskId, String bpmnErrorCode) {
        throw new UnsupportedOperationException();
    }

    public DE cancelUserTask(DE workflowAggregate, String taskId, String errorCode) {
        Object attachedAggregate = this.workflowAggregateRepository.save(workflowAggregate);
        this.wakeupJobExecutorOnActivity();
        this.processEngine.getTaskService().handleBpmnError(taskId, errorCode);
        return (DE)attachedAggregate;
    }

    private void wakeupJobExecutorOnActivity() {
        logger.debug("Wanna wake up job-executor");
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new WakupJobExecutorNotification(this.getClass().getName()));
    }
}

