/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda7.service.jobs.startprocess;

import io.vanillabp.camunda7.service.jobs.startprocess.StartProcessJobHandlerConfiguration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandler;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;

public class StartProcessJobHandler
implements JobHandler<StartProcessJobHandlerConfiguration> {
    private static final Pattern SPLITTER = Pattern.compile("([^\n]+)\n([^\n]+)\n(.*)");

    public String getType() {
        return "VBP_StartProcess";
    }

    public void execute(StartProcessJobHandlerConfiguration configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        commandContext.getProcessEngineConfiguration().getProcessEngine().getRuntimeService().createProcessInstanceByKey(configuration.getBpmnProcessId()).businessKey(configuration.getBusinessKey()).processDefinitionTenantId(configuration.getWorkflowModuleId()).execute();
    }

    public StartProcessJobHandlerConfiguration newConfiguration(String canonicalString) {
        if (canonicalString == null) {
            return null;
        }
        Matcher splitter = SPLITTER.matcher(canonicalString);
        if (!splitter.matches()) {
            return null;
        }
        return new StartProcessJobHandlerConfiguration(splitter.group(1), splitter.group(2), splitter.group(3));
    }

    public void onDelete(StartProcessJobHandlerConfiguration configuration, JobEntity jobEntity) {
    }
}

