/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda7.wiring;

import io.vanillabp.camunda7.wiring.Camunda7Connectable;
import io.vanillabp.camunda7.wiring.Camunda7UserTaskHandler;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.model.bpmn.instance.FlowElement;
import org.camunda.bpm.model.bpmn.instance.UserTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Camunda7UserTaskEventHandler
implements TaskListener {
    private static final Logger logger = LoggerFactory.getLogger(Camunda7UserTaskEventHandler.class);
    private final Map<Camunda7Connectable, Camunda7UserTaskHandler> taskHandlers = new HashMap<Camunda7Connectable, Camunda7UserTaskHandler>();

    public void addTaskHandler(Camunda7Connectable connectable, Camunda7UserTaskHandler taskHandler) {
        this.taskHandlers.put(connectable, taskHandler);
    }

    public void notify(DelegateTask delegateTask) {
        ExecutionEntity execution = (ExecutionEntity)delegateTask.getExecution();
        String bpmnProcessId = execution.getProcessDefinition().getKey();
        Camunda7Connectable[] connectableFound = new Camunda7Connectable[1];
        this.taskHandlers.entrySet().stream().filter(entry -> {
            Camunda7Connectable connectable = (Camunda7Connectable)entry.getKey();
            if (!connectable.getBpmnProcessId().equals(bpmnProcessId)) {
                return false;
            }
            FlowElement element = execution.getBpmnModelElementInstance();
            if (element == null) {
                return false;
            }
            return connectable.applies(element.getId(), ((UserTask)element).getCamundaFormKey());
        }).peek(entry -> {
            connectableFound[0] = (Camunda7Connectable)entry.getKey();
        }).filter(entry -> ((Camunda7UserTaskHandler)((Object)((Object)entry.getValue()))).eventApplies(delegateTask.getEventName())).findFirst().map(entry -> (Camunda7UserTaskHandler)((Object)((Object)entry.getValue()))).ifPresentOrElse(handler -> handler.notify(delegateTask), () -> logger.debug("Unmapped event '{}'! If you need to process this event add a parameter '@TaskEvent Event event' to the method annotated by '@WorkflowTask(taskDefinition = \"{}\") in any class annotated by '@WorkflowService(bpmnProcess = @BpmnProcess(bpmnProcessId = \"{}\"))'.", new Object[]{delegateTask.getEventName(), connectableFound[0].getTaskDefinition(), connectableFound[0].getBpmnProcessId()}));
    }
}

