/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda7;

import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="vanillabp", ignoreUnknownFields=true)
public class Camunda7VanillaBpProperties {
    private static final boolean DEFAULT_USEBPMNASYNCDEFINITIONS = false;
    private static final boolean DEFAULT_USETENANT = true;
    private Map<String, WorkflowModuleAdapterProperties> workflowModules = Map.of();
    private static final WorkflowModuleAdapterProperties defaultProperties = new WorkflowModuleAdapterProperties();
    private static final AdapterConfiguration defaultAdapterProperties = new AdapterConfiguration();

    public Map<String, WorkflowModuleAdapterProperties> getWorkflowModules() {
        return this.workflowModules;
    }

    public void setWorkflowModules(Map<String, WorkflowModuleAdapterProperties> workflowModules) {
        this.workflowModules = workflowModules;
        workflowModules.forEach((workflowModuleId, properties) -> {
            properties.workflowModuleId = workflowModuleId;
        });
    }

    public String getTenantId(String workflowModuleId) {
        AdapterConfiguration configuration = this.workflowModules.getOrDefault(workflowModuleId, defaultProperties).getAdapters().getOrDefault("camunda7", defaultAdapterProperties);
        if (!configuration.isUseTenants()) {
            return null;
        }
        if (StringUtils.hasText((String)configuration.getTenantId())) {
            return configuration.getTenantId();
        }
        return workflowModuleId;
    }

    public boolean useBpmnAsyncDefinitions(String workflowModuleId, String bpmnProcessId) {
        WorkflowAdapterProperties workflow;
        boolean result = false;
        WorkflowModuleAdapterProperties workflowModule = this.workflowModules.get(workflowModuleId);
        if (workflowModule == null) {
            return result;
        }
        AdapterConfiguration workflowModuleAdapter = workflowModule.getAdapters().get("camunda7");
        if (workflowModuleAdapter != null) {
            result = workflowModuleAdapter.isUseBpmnAsyncDefinitions();
        }
        if ((workflow = workflowModule.getWorkflows().get(bpmnProcessId)) == null) {
            return result;
        }
        AsyncProperties workflowAdapter = workflow.getAdapters().get("camunda7");
        if (workflowAdapter == null) {
            return result;
        }
        return workflowAdapter.isUseBpmnAsyncDefinitions();
    }

    public static class WorkflowModuleAdapterProperties {
        String workflowModuleId;
        private Map<String, AdapterConfiguration> adapters = Map.of();
        private Map<String, WorkflowAdapterProperties> workflows = Map.of();

        public Map<String, AdapterConfiguration> getAdapters() {
            return this.adapters;
        }

        public void setAdapters(Map<String, AdapterConfiguration> adapters) {
            this.adapters = adapters;
        }

        public Map<String, WorkflowAdapterProperties> getWorkflows() {
            return this.workflows;
        }

        public void setWorkflows(Map<String, WorkflowAdapterProperties> workflows) {
            this.workflows = workflows;
            workflows.forEach((bpmnProcessId, properties) -> {
                properties.bpmnProcessId = bpmnProcessId;
                properties.workflowModule = this;
            });
        }
    }

    public static class AdapterConfiguration
    extends AsyncProperties {
        private boolean useTenants = true;
        private String tenantId;

        public boolean isUseTenants() {
            return this.useTenants;
        }

        public void setUseTenants(boolean useTenants) {
            this.useTenants = useTenants;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }
    }

    public static class WorkflowAdapterProperties {
        String bpmnProcessId;
        WorkflowModuleAdapterProperties workflowModule;
        private Map<String, AsyncProperties> adapters = Map.of();

        public WorkflowModuleAdapterProperties getWorkflowModule() {
            return this.workflowModule;
        }

        public String getBpmnProcessId() {
            return this.bpmnProcessId;
        }

        public Map<String, AsyncProperties> getAdapters() {
            return this.adapters;
        }

        public void setAdapters(Map<String, AsyncProperties> adapters) {
            this.adapters = adapters;
        }
    }

    public static class AsyncProperties {
        private boolean useBpmnAsyncDefinitions = false;

        public boolean isUseBpmnAsyncDefinitions() {
            return this.useBpmnAsyncDefinitions;
        }

        public void setUseBpmnAsyncDefinitions(boolean useBpmnAsyncDefinitions) {
            this.useBpmnAsyncDefinitions = useBpmnAsyncDefinitions;
        }
    }
}

