/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda7.wiring;

import io.vanillabp.camunda7.service.Camunda7ProcessService;
import io.vanillabp.camunda7.wiring.Camunda7TaskHandler;
import io.vanillabp.spi.service.TaskEvent;
import io.vanillabp.springboot.adapter.MultiInstance;
import io.vanillabp.springboot.adapter.TaskHandlerBase;
import io.vanillabp.springboot.adapter.wiring.WorkflowAggregateCache;
import io.vanillabp.springboot.parameters.MethodParameter;
import io.vanillabp.springboot.parameters.TaskEventMethodParameter;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.repository.CrudRepository;

public class Camunda7UserTaskHandler
extends TaskHandlerBase
implements TaskListener {
    private static final Logger logger = LoggerFactory.getLogger(Camunda7UserTaskHandler.class);
    private final Camunda7ProcessService<?> processService;
    private final String bpmnProcessId;

    public Camunda7UserTaskHandler(String bpmnProcessId, CrudRepository<Object, Object> workflowAggregateRepository, Object bean, Method method, List<MethodParameter> parameters, Camunda7ProcessService<?> processService) {
        super(workflowAggregateRepository, bean, method, parameters);
        this.bpmnProcessId = bpmnProcessId;
        this.processService = processService;
    }

    protected Logger getLogger() {
        return logger;
    }

    public void notify(DelegateTask delegateTask) {
        Map[] multiInstanceCache = new Map[]{null};
        try {
            logger.trace("Will handle user-task '{}' of workflow '{}' ('{}') by execution '{}'", new Object[]{delegateTask.getBpmnModelElementInstance().getId(), delegateTask.getProcessInstanceId(), this.bpmnProcessId, delegateTask.getExecutionId()});
            DelegateExecution execution = delegateTask.getExecution();
            Function<String, Object> multiInstanceSupplier = multiInstanceActivity -> {
                if (multiInstanceCache[0] == null) {
                    multiInstanceCache[0] = Camunda7TaskHandler.getMultiInstanceContext(execution);
                }
                return multiInstanceCache[0].get(multiInstanceActivity);
            };
            Object workflowAggregateId = this.processService.getWorkflowAggregateIdFromBusinessKey(execution.getBusinessKey());
            WorkflowAggregateCache workflowAggregateCache = new WorkflowAggregateCache();
            super.execute(workflowAggregateCache, workflowAggregateId, true, new BiFunction[]{(args, param) -> this.processTaskParameter((Object[])args, (MethodParameter)param, taskParameter -> execution.getVariableLocal(taskParameter)), (args, param) -> this.processTaskIdParameter((Object[])args, (MethodParameter)param, () -> delegateTask.getId()), (args, param) -> this.processTaskEventParameter((Object[])args, (MethodParameter)param, () -> "delete".equals(delegateTask.getEventName()) ? TaskEvent.Event.CANCELED : TaskEvent.Event.CREATED), (args, param) -> this.processMultiInstanceIndexParameter((Object[])args, (MethodParameter)param, multiInstanceSupplier), (args, param) -> this.processMultiInstanceTotalParameter((Object[])args, (MethodParameter)param, multiInstanceSupplier), (args, param) -> this.processMultiInstanceElementParameter((Object[])args, (MethodParameter)param, multiInstanceSupplier), (args, param) -> this.processMultiInstanceResolverParameter((Object[])args, (MethodParameter)param, () -> {
                if (workflowAggregateCache.workflowAggregate == null) {
                    workflowAggregateCache.workflowAggregate = this.workflowAggregateRepository.findById(workflowAggregateId).orElseThrow();
                }
                return workflowAggregateCache.workflowAggregate;
            }, multiInstanceSupplier)});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean eventApplies(String eventName) {
        TaskEvent.Event event = this.getTaskEvent(eventName);
        if (event == null) {
            return false;
        }
        return this.parameters.stream().filter(parameter -> parameter instanceof TaskEventMethodParameter).map(parameter -> ((TaskEventMethodParameter)parameter).getEvents()).findFirst().orElse(Set.of(TaskEvent.Event.CREATED)).contains(event);
    }

    protected TaskEvent.Event getTaskEvent(String eventName) {
        switch (eventName) {
            case "delete": {
                return TaskEvent.Event.CANCELED;
            }
            case "create": {
                return TaskEvent.Event.CREATED;
            }
        }
        return null;
    }

    protected MultiInstance<Object> getMultiInstance(String name, Function<String, Object> multiInstanceSupplier) {
        return (MultiInstance)multiInstanceSupplier.apply(name);
    }

    protected Object getMultiInstanceElement(String name, Function<String, Object> multiInstanceSupplier) {
        return ((MultiInstance)multiInstanceSupplier.apply(name)).getElement();
    }

    protected Integer getMultiInstanceTotal(String name, Function<String, Object> multiInstanceSupplier) {
        return ((MultiInstance)multiInstanceSupplier.apply(name)).getTotal();
    }

    protected Integer getMultiInstanceIndex(String name, Function<String, Object> multiInstanceSupplier) {
        return ((MultiInstance)multiInstanceSupplier.apply(name)).getIndex();
    }
}

