/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda7.wiring;

import io.vanillabp.camunda7.Camunda7VanillaBpProperties;
import io.vanillabp.camunda7.service.Camunda7ProcessService;
import io.vanillabp.camunda7.wiring.Camunda7Connectable;
import io.vanillabp.camunda7.wiring.Camunda7TaskHandler;
import io.vanillabp.camunda7.wiring.Camunda7UserTaskEventHandler;
import io.vanillabp.camunda7.wiring.Camunda7UserTaskHandler;
import io.vanillabp.camunda7.wiring.ProcessEntityAwareExpressionManager;
import io.vanillabp.spi.process.ProcessService;
import io.vanillabp.spi.service.WorkflowTask;
import io.vanillabp.springboot.adapter.Connectable;
import io.vanillabp.springboot.adapter.SpringBeanUtil;
import io.vanillabp.springboot.adapter.TaskWiringBase;
import io.vanillabp.springboot.parameters.MethodParameter;
import io.vanillabp.springboot.parameters.MethodParameterFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Component;

@Component
public class Camunda7TaskWiring
extends TaskWiringBase<Camunda7Connectable, Camunda7ProcessService<?>, MethodParameterFactory> {
    private final ProcessEntityAwareExpressionManager processEntityAwareExpressionManager;
    private final Collection<Camunda7ProcessService<?>> connectableServices;
    private final Camunda7UserTaskEventHandler userTaskEventHandler;
    private final Camunda7VanillaBpProperties camunda7Properties;

    public Camunda7TaskWiring(ApplicationContext applicationContext, SpringBeanUtil springBeanUtil, ProcessEntityAwareExpressionManager processEntityAwareExpressionManager, Camunda7UserTaskEventHandler userTaskEventHandler, Collection<Camunda7ProcessService<?>> connectableServices, Camunda7VanillaBpProperties camunda7Properties) {
        super(applicationContext, springBeanUtil);
        this.processEntityAwareExpressionManager = processEntityAwareExpressionManager;
        this.userTaskEventHandler = userTaskEventHandler;
        this.connectableServices = connectableServices;
        this.camunda7Properties = camunda7Properties;
    }

    protected Class<WorkflowTask> getAnnotationType() {
        return WorkflowTask.class;
    }

    protected void connectToBpms(String workflowModuleId, Camunda7ProcessService<?> processService, Object bean, Camunda7Connectable connectable, Method method, List<MethodParameter> parameters) {
        CrudRepository<?, Object> repository = processService.getWorkflowAggregateRepository();
        if (connectable.getType() == Camunda7Connectable.Type.USERTASK) {
            Camunda7UserTaskHandler taskHandler = new Camunda7UserTaskHandler(connectable.getBpmnProcessId(), repository, bean, method, parameters, processService, workflowModuleId);
            this.userTaskEventHandler.addTaskHandler(connectable, taskHandler);
            return;
        }
        String tenantId = this.camunda7Properties.getTenantId(workflowModuleId);
        Camunda7TaskHandler taskHandler = new Camunda7TaskHandler(connectable.getBpmnProcessId(), repository, bean, method, parameters, processService, tenantId, workflowModuleId);
        this.processEntityAwareExpressionManager.addTaskHandler(connectable, taskHandler);
    }

    protected <DE> Camunda7ProcessService<?> connectToBpms(String workflowModuleId, Class<DE> workflowAggregateClass, String bpmnProcessId, boolean isPrimary, Collection<String> messageBasedStartEventsMessageNames, Collection<String> signalBasedStartEventsSignalNames) {
        Camunda7ProcessService processService = this.connectableServices.stream().filter(service -> service.getWorkflowAggregateClass().equals(workflowAggregateClass)).findFirst().orElseThrow(() -> new RuntimeException("You need to autowire '" + ProcessService.class.getName() + "<" + workflowAggregateClass.getName() + ">' in your code to be able to start workflows!"));
        processService.wire(workflowModuleId, bpmnProcessId, isPrimary, messageBasedStartEventsMessageNames, signalBasedStartEventsSignalNames);
        return processService;
    }

    public void validateWiring() {
        if (this.connectableServices.stream().filter(Camunda7ProcessService::testForNotYetWired).count() > 0L) {
            throw new RuntimeException("At least one ProcessService bean was not wired! See previous ERROR logs for details.");
        }
    }

    protected void wireTask(String workflowModuleId, Camunda7ProcessService<?> processService, Camunda7Connectable connectable) {
        super.wireTask((Connectable)connectable, false, (method, annotation) -> this.methodMatchesTaskDefinition(connectable, (Method)method, (WorkflowTask)annotation), (method, annotation) -> this.methodMatchesElementId(connectable, (Method)method, (Annotation)annotation), (method, annotation) -> this.validateParameters(processService, (Method)method), (bean, method, parameters) -> this.connectToBpms(workflowModuleId, processService, bean, connectable, method, (List<MethodParameter>)parameters));
    }
}

