/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda7.service;

import io.vanillabp.camunda7.Camunda7VanillaBpProperties;
import io.vanillabp.camunda7.LoggingContext;
import io.vanillabp.camunda7.service.WakupJobExecutorNotification;
import io.vanillabp.camunda7.service.jobs.startprocess.StartProcessCommand;
import io.vanillabp.springboot.adapter.AdapterAwareProcessService;
import io.vanillabp.springboot.adapter.ProcessServiceImplementation;
import java.util.Collection;
import java.util.function.Function;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ExecutionQuery;
import org.camunda.bpm.engine.runtime.MessageCorrelationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.repository.CrudRepository;

public class Camunda7ProcessService<DE>
implements ProcessServiceImplementation<DE> {
    private static final Logger logger = LoggerFactory.getLogger(Camunda7ProcessService.class);
    private final ApplicationEventPublisher applicationEventPublisher;
    private final ProcessEngine processEngine;
    private final CrudRepository<DE, Object> workflowAggregateRepository;
    private final Class<DE> workflowAggregateClass;
    private final Function<DE, ?> getWorkflowAggregateId;
    private final Function<DE, Boolean> isNewEntity;
    private final Function<String, Object> parseWorkflowAggregateIdFromBusinessKey;
    private final Camunda7VanillaBpProperties camunda7Properties;
    private AdapterAwareProcessService<DE> parent;

    public Camunda7ProcessService(ApplicationEventPublisher applicationEventPublisher, Camunda7VanillaBpProperties camunda7Properties, ProcessEngine processEngine, Function<DE, Boolean> isNewEntity, Function<DE, ?> getWorkflowAggregateId, CrudRepository<DE, Object> workflowAggregateRepository, Class<DE> workflowAggregateClass, Function<String, Object> parseWorkflowAggregateIdFromBusinessKey) {
        this.applicationEventPublisher = applicationEventPublisher;
        this.camunda7Properties = camunda7Properties;
        this.processEngine = processEngine;
        this.workflowAggregateRepository = workflowAggregateRepository;
        this.workflowAggregateClass = workflowAggregateClass;
        this.isNewEntity = isNewEntity;
        this.getWorkflowAggregateId = getWorkflowAggregateId;
        this.parseWorkflowAggregateIdFromBusinessKey = parseWorkflowAggregateIdFromBusinessKey;
    }

    public void setParent(AdapterAwareProcessService<DE> parent) {
        this.parent = parent;
    }

    public Collection<String> getBpmnProcessIds() {
        return this.parent.getBpmnProcessIds();
    }

    public String getPrimaryBpmnProcessId() {
        return this.parent.getPrimaryBpmnProcessId();
    }

    public void wire(String workflowModuleId, String bpmnProcessId, boolean isPrimary, Collection<String> messageBasedStartEventsMessageNames, Collection<String> signalBasedStartEventsSignalNames) {
        if (this.parent == null) {
            throw new RuntimeException("Not yet wired! If this occurs Spring Boot dependency of either VanillaBP Spring Boot support or Camunda7 adapter was changed introducing this lack of wiring. Please report a Github issue!");
        }
        this.parent.wire("camunda7", workflowModuleId, bpmnProcessId, isPrimary, messageBasedStartEventsMessageNames, signalBasedStartEventsSignalNames);
    }

    public boolean testForNotYetWired() {
        if (this.parent.getPrimaryBpmnProcessId() == null) {
            logger.error("The bean ProcessService<{}> was not wired to a BPMN process! It is likely that the BPMN is not part of the classpath.", (Object)this.workflowAggregateClass.getName());
            return true;
        }
        return false;
    }

    public Class<DE> getWorkflowAggregateClass() {
        return this.workflowAggregateClass;
    }

    public CrudRepository<DE, Object> getWorkflowAggregateRepository() {
        return this.workflowAggregateRepository;
    }

    public Object getWorkflowAggregateIdFromBusinessKey(String businessKey) {
        return this.parseWorkflowAggregateIdFromBusinessKey.apply(businessKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DE startWorkflow(DE workflowAggregate) throws Exception {
        try {
            Object attachedAggregate = this.workflowAggregateRepository.save(workflowAggregate);
            String aggregateId = this.getWorkflowAggregateId.apply(attachedAggregate).toString();
            String tenantId = this.camunda7Properties.getTenantId(this.parent.getWorkflowModuleId());
            String bpmnProcessId = this.parent.getPrimaryBpmnProcessId();
            LoggingContext.setLoggingContext("camunda7", this.camunda7Properties.getTenantId(this.parent.getWorkflowModuleId()), this.parent.getWorkflowModuleId(), aggregateId, bpmnProcessId, null, null, null, null);
            this.wakeupJobExecutorOnActivity();
            ((ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration()).getCommandExecutorTxRequired().execute((Command)new StartProcessCommand(tenantId, bpmnProcessId, aggregateId));
            Object object = attachedAggregate;
            return (DE)object;
        }
        finally {
            LoggingContext.clearContext();
        }
    }

    public DE correlateMessage(DE workflowAggregate, String messageName) {
        return this.correlateMessage(workflowAggregate, messageName, null, null);
    }

    public DE correlateMessage(DE workflowAggregate, Object message) {
        return this.correlateMessage(workflowAggregate, message.getClass().getSimpleName());
    }

    public DE correlateMessage(DE workflowAggregate, String messageName, String correlationId) {
        String correlationIdLocalVariableName = this.parent.getPrimaryBpmnProcessId() + "-" + messageName;
        return this.correlateMessage(workflowAggregate, messageName, correlationIdLocalVariableName, correlationId);
    }

    public DE correlateMessage(DE workflowAggregate, Object message, String correlationId) {
        return this.correlateMessage(workflowAggregate, message.getClass().getSimpleName(), correlationId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DE correlateMessage(DE workflowAggregate, String messageName, String correlationIdLocalVariableName, String correlationId) {
        try {
            boolean hasMessageCorrelation;
            Boolean isNewEntity = this.isNewEntity.apply(workflowAggregate);
            Object attachedAggregate = this.workflowAggregateRepository.save(workflowAggregate);
            String aggregateId = this.getWorkflowAggregateId.apply(attachedAggregate).toString();
            String bpmnProcessId = this.parent.getPrimaryBpmnProcessId();
            String tenantId = this.camunda7Properties.getTenantId(this.parent.getWorkflowModuleId());
            LoggingContext.setLoggingContext("camunda7", tenantId, this.parent.getWorkflowModuleId(), aggregateId, bpmnProcessId, null, null, null, null);
            MessageCorrelationBuilder correlation = (tenantId == null ? this.processEngine.getRuntimeService().createMessageCorrelation(messageName) : this.processEngine.getRuntimeService().createMessageCorrelation(messageName).tenantId(tenantId)).processInstanceBusinessKey(aggregateId);
            if (correlationIdLocalVariableName != null) {
                correlation.localVariableEquals(correlationIdLocalVariableName, (Object)correlationId);
            }
            this.wakeupJobExecutorOnActivity();
            if (isNewEntity.booleanValue()) {
                ProcessInstance result = correlation.correlateStartMessage();
                logger.trace("Started process '{}#{}' by message-correlation '{}' (tenant: {})", new Object[]{bpmnProcessId, result.getProcessInstanceId(), messageName, result.getTenantId()});
                Object object = attachedAggregate;
                return (DE)object;
            }
            ExecutionQuery correlationExecutions = (tenantId == null ? this.processEngine.getRuntimeService().createExecutionQuery() : this.processEngine.getRuntimeService().createExecutionQuery().tenantIdIn(new String[]{tenantId})).messageEventSubscriptionName(messageName).processInstanceBusinessKey(aggregateId).active();
            if (correlationIdLocalVariableName != null) {
                correlationExecutions.variableValueEquals(correlationIdLocalVariableName, (Object)correlationId);
            }
            boolean bl = hasMessageCorrelation = correlationExecutions.count() == 1L;
            if (!hasMessageCorrelation) {
                logger.trace("Message '{}' of process having bpmn-process-id '{}' could not be correlated using correlation-id '{}' for workflow aggregate '{}'!", new Object[]{messageName, bpmnProcessId, correlationId, aggregateId});
                Object object = attachedAggregate;
                return (DE)object;
            }
            Execution result = correlation.correlateWithResult().getExecution();
            logger.trace("Correlated message '{}' using correlation-id '{}' for process '{}#{}' and execution '{}' (tenant: {})", new Object[]{messageName, correlationId, bpmnProcessId, result.getProcessInstanceId(), result.getId(), result.getTenantId()});
            Object object = attachedAggregate;
            return (DE)object;
        }
        finally {
            LoggingContext.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DE completeUserTask(DE workflowAggregate, String taskId) {
        try {
            Object attachedAggregate = this.workflowAggregateRepository.save(workflowAggregate);
            String aggregateId = this.getWorkflowAggregateId.apply(workflowAggregate).toString();
            String tenantId = this.camunda7Properties.getTenantId(this.parent.getWorkflowModuleId());
            Task task = (Task)(tenantId == null ? this.processEngine.getTaskService().createTaskQuery() : this.processEngine.getTaskService().createTaskQuery().tenantIdIn(new String[]{tenantId})).processInstanceBusinessKey(aggregateId).taskId(taskId).singleResult();
            if (task == null) {
                throw new NullValueException("Task '" + taskId + "' not found!");
            }
            String bpmnProcessId = this.parent.getPrimaryBpmnProcessId();
            LoggingContext.setLoggingContext("camunda7", tenantId, this.parent.getWorkflowModuleId(), aggregateId, bpmnProcessId, taskId, task.getProcessInstanceId(), task.getProcessDefinitionId() + "#" + task.getTaskDefinitionKey(), task.getExecutionId());
            this.wakeupJobExecutorOnActivity();
            this.processEngine.getTaskService().complete(taskId);
            Object object = attachedAggregate;
            return (DE)object;
        }
        finally {
            LoggingContext.clearContext();
        }
    }

    public DE completeTask(DE workflowAggregate, String taskId) {
        throw new UnsupportedOperationException();
    }

    public DE cancelTask(DE workflowAggregate, String taskId, String bpmnErrorCode) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DE cancelUserTask(DE workflowAggregate, String taskId, String errorCode) {
        try {
            Object attachedAggregate = this.workflowAggregateRepository.save(workflowAggregate);
            String aggregateId = this.getWorkflowAggregateId.apply(workflowAggregate).toString();
            String tenantId = this.camunda7Properties.getTenantId(this.parent.getWorkflowModuleId());
            Task task = (Task)(tenantId == null ? this.processEngine.getTaskService().createTaskQuery() : this.processEngine.getTaskService().createTaskQuery().tenantIdIn(new String[]{tenantId})).processInstanceBusinessKey(aggregateId).taskId(taskId).singleResult();
            if (task == null) {
                throw new NullValueException("Task '" + taskId + "' not found!");
            }
            String bpmnProcessId = this.parent.getPrimaryBpmnProcessId();
            LoggingContext.setLoggingContext("camunda7", tenantId, this.parent.getWorkflowModuleId(), aggregateId, bpmnProcessId, taskId, task.getProcessInstanceId(), task.getTaskDefinitionKey(), task.getExecutionId());
            this.wakeupJobExecutorOnActivity();
            this.processEngine.getTaskService().handleBpmnError(taskId, errorCode);
            Object object = attachedAggregate;
            return (DE)object;
        }
        finally {
            LoggingContext.clearContext();
        }
    }

    private void wakeupJobExecutorOnActivity() {
        logger.debug("Wanna wake up job-executor");
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new WakupJobExecutorNotification(this.getClass().getName()));
    }
}

