/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda7.cockpit;

import io.vanillabp.camunda7.service.WakupJobExecutorNotification;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.scheduling.TaskScheduler;

public class WakeupFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(WakeupFilter.class);
    private static final long DEBOUNCE_MILLIS = 500L;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final TaskScheduler taskScheduler;
    private static long lastWakeup;

    public WakeupFilter(ApplicationEventPublisher applicationEventPublisher, TaskScheduler taskScheduler) {
        this.applicationEventPublisher = applicationEventPublisher;
        this.taskScheduler = taskScheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        }
        finally {
            lastWakeup = System.currentTimeMillis();
            this.taskScheduler.schedule(this::wakeupJobExecutorOnActivity, new Date(lastWakeup + 500L));
        }
    }

    private void wakeupJobExecutorOnActivity() {
        long diff = System.currentTimeMillis() - lastWakeup;
        if (diff < 500L) {
            return;
        }
        logger.debug("Wanna wake up job-executor");
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new WakupJobExecutorNotification(this.getClass().getName()));
    }
}

