/*
 * Decompiled with CFR 0.152.
 */
package io.vanillabp.camunda7.wiring;

import io.vanillabp.camunda7.LoggingContext;
import io.vanillabp.camunda7.service.Camunda7ProcessService;
import io.vanillabp.spi.service.MultiInstanceElementResolver;
import io.vanillabp.spi.service.TaskEvent;
import io.vanillabp.spi.service.TaskException;
import io.vanillabp.springboot.adapter.MultiInstance;
import io.vanillabp.springboot.adapter.TaskHandlerBase;
import io.vanillabp.springboot.adapter.wiring.WorkflowAggregateCache;
import io.vanillabp.springboot.parameters.MethodParameter;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.model.bpmn.instance.Activity;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.FlowElement;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.camunda.bpm.model.bpmn.instance.MultiInstanceLoopCharacteristics;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.xml.ModelInstance;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.repository.CrudRepository;
import org.springframework.transaction.annotation.Transactional;

public class Camunda7TaskHandler
extends TaskHandlerBase
implements JavaDelegate {
    private static final Logger logger = LoggerFactory.getLogger(Camunda7TaskHandler.class);
    private final String bpmnProcessId;
    private final String tenantId;
    private final String workflowModuleId;
    private Object result;
    private final Camunda7ProcessService<?> processService;

    public Camunda7TaskHandler(String bpmnProcessId, CrudRepository<Object, Object> workflowAggregateRepository, Object bean, Method method, List<MethodParameter> parameters, Camunda7ProcessService<?> processService, String tenantId, String workflowModuleId) {
        super(workflowAggregateRepository, bean, method, parameters);
        this.bpmnProcessId = bpmnProcessId;
        this.processService = processService;
        this.tenantId = tenantId;
        this.workflowModuleId = workflowModuleId;
    }

    protected Logger getLogger() {
        return logger;
    }

    public String getMethodName() {
        return this.method.getName();
    }

    @Transactional(noRollbackFor={BpmnError.class})
    public void execute(DelegateExecution execution) throws Exception {
        Map[] multiInstanceCache = new Map[]{null};
        try {
            FlowNode currentElement = (FlowNode)Camunda7TaskHandler.getCurrentElement((ModelInstance)execution.getBpmnModelInstance(), execution);
            LoggingContext.setLoggingContext("camunda7", this.tenantId, this.workflowModuleId, execution.getBusinessKey(), this.bpmnProcessId, execution.getId(), Camunda7TaskHandler.getSuperProcessInstanceId(execution), Camunda7TaskHandler.getBpmnProcessId(execution) + "#" + currentElement.getId(), execution.getId());
            logger.trace("Will handle task '{}' of workflow '{}' ('{}') by execution '{}'", new Object[]{currentElement.getId(), execution.getProcessInstanceId(), this.bpmnProcessId, execution.getId()});
            Function<String, Object> multiInstanceSupplier = multiInstanceActivity -> {
                if (multiInstanceCache[0] == null) {
                    multiInstanceCache[0] = Camunda7TaskHandler.getMultiInstanceContext(execution);
                }
                return multiInstanceCache[0].get(multiInstanceActivity);
            };
            Object workflowAggregateId = this.processService.getWorkflowAggregateIdFromBusinessKey(execution.getBusinessKey());
            WorkflowAggregateCache workflowAggregateCache = new WorkflowAggregateCache();
            super.execute(workflowAggregateCache, workflowAggregateId, true, new BiFunction[]{(args, param) -> this.processTaskParameter((Object[])args, (MethodParameter)param, arg_0 -> ((DelegateExecution)execution).getVariableLocal(arg_0)), (args, param) -> this.processTaskEventParameter((Object[])args, (MethodParameter)param, () -> TaskEvent.Event.CREATED), (args, param) -> this.processMultiInstanceIndexParameter((Object[])args, (MethodParameter)param, multiInstanceSupplier), (args, param) -> this.processMultiInstanceTotalParameter((Object[])args, (MethodParameter)param, multiInstanceSupplier), (args, param) -> this.processMultiInstanceElementParameter((Object[])args, (MethodParameter)param, multiInstanceSupplier), (args, param) -> this.processMultiInstanceResolverParameter((Object[])args, (MethodParameter)param, () -> {
                if (workflowAggregateCache.workflowAggregate == null) {
                    workflowAggregateCache.workflowAggregate = this.workflowAggregateRepository.findById(workflowAggregateId).orElseThrow();
                }
                return workflowAggregateCache.workflowAggregate;
            }, multiInstanceSupplier)});
        }
        catch (TaskException e) {
            if (e.getErrorName() != null) {
                throw new BpmnError(e.getErrorCode(), e.getErrorName(), (Throwable)e);
            }
            throw new BpmnError(e.getErrorCode(), (Throwable)e);
        }
        finally {
            LoggingContext.clearContext();
        }
    }

    public Object getResult() {
        return this.result;
    }

    static String getSuperProcessInstanceId(DelegateExecution execution) {
        String result;
        DelegateExecution cExecution = execution;
        do {
            result = cExecution.getProcessInstanceId();
        } while ((cExecution = cExecution.getParentId() != null ? ((ExecutionEntity)cExecution).getParent() : cExecution.getSuperExecution()) != null);
        return result;
    }

    static String getBpmnProcessId(DelegateExecution execution) {
        DelegateExecution cExecution = execution;
        do {
            FlowElement flowElement;
            if (!((flowElement = cExecution.getBpmnModelElementInstance()) instanceof Process)) continue;
            return flowElement.getId();
        } while ((cExecution = cExecution.getParentId() != null ? ((ExecutionEntity)cExecution).getParent() : cExecution.getSuperExecution()) != null);
        return null;
    }

    static Map<String, MultiInstanceElementResolver.MultiInstance<Object>> getMultiInstanceContext(DelegateExecution execution) {
        LinkedHashMap<String, MultiInstanceElementResolver.MultiInstance<Object>> result = new LinkedHashMap<String, MultiInstanceElementResolver.MultiInstance<Object>>();
        ModelInstance model = execution.getBpmnModelElementInstance().getModelInstance();
        DelegateExecution miExecution = execution;
        MultiInstanceLoopCharacteristics loopCharacteristics = null;
        while (loopCharacteristics == null) {
            ModelElementInstance bpmnElement = Camunda7TaskHandler.getCurrentElement(model, miExecution);
            if (bpmnElement instanceof Activity) {
                loopCharacteristics = (MultiInstanceLoopCharacteristics)((Activity)bpmnElement).getLoopCharacteristics();
            }
            if (loopCharacteristics == null) {
                miExecution = miExecution.getParentId() != null ? ((ExecutionEntity)miExecution).getParent() : miExecution.getSuperExecution();
            } else {
                Integer itemNo = (Integer)miExecution.getVariable("loopCounter");
                Integer totalCount = (Integer)miExecution.getVariable("nrOfInstances");
                Object currentItem = loopCharacteristics.getCamundaElementVariable() == null ? null : miExecution.getVariable(loopCharacteristics.getCamundaElementVariable());
                result.put(((BaseElement)bpmnElement).getId(), (MultiInstanceElementResolver.MultiInstance<Object>)new MultiInstance(currentItem, totalCount.intValue(), itemNo.intValue()));
            }
            if (miExecution != null || loopCharacteristics != null) continue;
            throw new RuntimeException("No multi-instance context found for element '" + execution.getBpmnModelElementInstance().getId() + "' or its parents!");
        }
        return result;
    }

    static ModelElementInstance getCurrentElement(ModelInstance model, DelegateExecution miExecution) {
        if (miExecution.getBpmnModelElementInstance() != null) {
            return miExecution.getBpmnModelElementInstance();
        }
        String activityInstanceId = miExecution.getActivityInstanceId();
        int elementMarker = activityInstanceId.indexOf(58);
        if (elementMarker == -1) {
            return null;
        }
        return model.getModelElementById(activityInstanceId.substring(0, elementMarker));
    }
}

