/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.vanillabp.c8.deployment;

import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.impl.BpmnParser;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.vanillabp.springboot.adapter.SpringDataUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.camunda.community.vanillabp.c8.deployment.DeployedBpmn;
import org.camunda.community.vanillabp.c8.deployment.DeployedProcess;
import org.camunda.community.vanillabp.c8.deployment.DeployedProcessRepository;
import org.camunda.community.vanillabp.c8.deployment.Deployment;
import org.camunda.community.vanillabp.c8.deployment.DeploymentRepository;
import org.camunda.community.vanillabp.c8.deployment.DeploymentResource;
import org.camunda.community.vanillabp.c8.deployment.DeploymentResourceRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentService {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentService.class);
    private final BpmnParser bpmnParser = new BpmnParser();
    private final SpringDataUtil springDataUtil;
    private final DeployedProcessRepository deployedProcessRepository;
    private final DeploymentRepository deploymentRepository;
    private final DeploymentResourceRepository deploymentResourceRepository;
    private final Map<Long, Process> cachedProcesses = new HashMap<Long, Process>();

    public DeploymentService(SpringDataUtil springDataUtil, DeploymentRepository deploymentRepository, DeploymentResourceRepository deploymentResourceRepository, DeployedProcessRepository deployedProcessRepository) {
        this.springDataUtil = springDataUtil;
        this.deploymentRepository = deploymentRepository;
        this.deploymentResourceRepository = deploymentResourceRepository;
        this.deployedProcessRepository = deployedProcessRepository;
    }

    public DeployedBpmn addBpmn(BpmnModelInstance model, int fileId, String resourceName) {
        Optional previous = this.deploymentResourceRepository.findById(fileId);
        if (previous.isPresent()) {
            return (DeployedBpmn)previous.get();
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Bpmn.writeModelToStream((OutputStream)outStream, (BpmnModelInstance)model);
        DeployedBpmn bpmn = new DeployedBpmn();
        bpmn.setFileId(fileId);
        bpmn.setResource(outStream.toByteArray());
        bpmn.setResourceName(resourceName);
        return (DeployedBpmn)this.deploymentResourceRepository.save(bpmn);
    }

    public DeployedProcess addProcess(int packageId, io.camunda.zeebe.client.api.response.Process camunda8DeployedProcess, DeployedBpmn bpmn) {
        long versionedId = camunda8DeployedProcess.getProcessDefinitionKey();
        Optional previous = this.deploymentRepository.findById(versionedId);
        if (previous.isPresent() && ((Deployment)previous.get()).getPackageId() == packageId) {
            return (DeployedProcess)previous.get();
        }
        DeployedProcess deployedProcess = new DeployedProcess();
        deployedProcess.setDefinitionKey(versionedId);
        deployedProcess.setVersion(camunda8DeployedProcess.getVersion());
        deployedProcess.setPackageId(packageId);
        deployedProcess.setBpmnProcessId(camunda8DeployedProcess.getBpmnProcessId());
        deployedProcess.setDeployedResource(bpmn);
        deployedProcess.setPublishedAt(OffsetDateTime.now());
        return (DeployedProcess)this.deploymentRepository.save(deployedProcess);
    }

    public List<DeployedBpmn> getBpmnNotOfPackage(int packageId) {
        return this.deployedProcessRepository.findDistinctDeployedResourceByPackageIdNot(packageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Process getProcess(long processDefinitionKey) {
        Map<Long, Process> map = this.cachedProcesses;
        synchronized (map) {
            Process cached = this.cachedProcesses.get(processDefinitionKey);
            if (cached != null) {
                return cached;
            }
            DeployedProcess deployedProcess = (DeployedProcess)this.springDataUtil.unproxy((Object)((Deployment)this.deploymentRepository.findById(processDefinitionKey).orElseThrow()));
            DeploymentResource deployedResource = deployedProcess.getDeployedResource();
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(deployedResource.getResource());){
                this.bpmnParser.parseModelFromStream((InputStream)inputStream).getModelElementsByType(Process.class).stream().filter(Process::isExecutable).map(process -> {
                    long key = deployedResource.getDeployments().stream().filter(deployment -> ((DeployedProcess)deployment).getBpmnProcessId().equals(process.getId())).findFirst().get().getDefinitionKey();
                    return Map.entry(key, process);
                }).forEach(entry -> this.cachedProcesses.put((Long)entry.getKey(), (Process)entry.getValue()));
            }
            catch (Exception e) {
                logger.warn("Could not parse stored BPMN resource '{}'!", (Object)deployedResource.getResourceName());
            }
            return this.cachedProcesses.get(processDefinitionKey);
        }
    }
}

