/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.vanillabp.c8.service;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.response.PublishMessageResponse;
import io.vanillabp.springboot.adapter.ProcessServiceImplementation;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.repository.CrudRepository;

public class Camunda8ProcessService<DE>
implements ProcessServiceImplementation<DE> {
    private static final Logger logger = LoggerFactory.getLogger(Camunda8ProcessService.class);
    private final CrudRepository<DE, String> workflowAggregateRepository;
    private final Class<DE> workflowAggregateClass;
    private final Function<DE, String> getWorkflowAggregateId;
    private ZeebeClient client;
    private String workflowModuleId;
    private String bpmnProcessId;

    public Camunda8ProcessService(CrudRepository<DE, String> workflowAggregateRepository, Function<DE, String> getWorkflowAggregateId, Class<DE> workflowAggregateClass) {
        this.workflowAggregateRepository = workflowAggregateRepository;
        this.workflowAggregateClass = workflowAggregateClass;
        this.getWorkflowAggregateId = getWorkflowAggregateId;
    }

    public void wire(ZeebeClient client, String workflowModuleId, String bpmnProcessId) {
        this.client = client;
        this.workflowModuleId = workflowModuleId;
        this.bpmnProcessId = bpmnProcessId;
    }

    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    public Class<DE> getWorkflowAggregateClass() {
        return this.workflowAggregateClass;
    }

    public CrudRepository<DE, String> getWorkflowAggregateRepository() {
        return this.workflowAggregateRepository;
    }

    public DE startWorkflow(DE workflowAggregate) throws Exception {
        this.client.newCreateInstanceCommand().bpmnProcessId(this.bpmnProcessId).latestVersion().variables(workflowAggregate).send().get(10L, TimeUnit.SECONDS);
        return (DE)this.workflowAggregateRepository.save(workflowAggregate);
    }

    public DE correlateMessage(DE workflowAggregate, String messageName) {
        Object attachedEntity = this.workflowAggregateRepository.save(workflowAggregate);
        String correlationId = this.getWorkflowAggregateId.apply(workflowAggregate);
        this.correlateMessage(workflowAggregate, messageName, correlationId);
        return (DE)attachedEntity;
    }

    public DE correlateMessage(DE workflowAggregate, Object message) {
        return this.correlateMessage(workflowAggregate, message.getClass().getSimpleName());
    }

    public DE correlateMessage(DE workflowAggregate, String messageName, String correlationId) {
        Object attachedEntity = this.workflowAggregateRepository.save(workflowAggregate);
        long messageKey = ((PublishMessageResponse)this.client.newPublishMessageCommand().messageName(messageName).correlationKey(correlationId).variables(workflowAggregate).send().join()).getMessageKey();
        logger.trace("Correlated message '{}' using correlation-id '{}' for process '{}' as '{}'", new Object[]{messageName, correlationId, this.bpmnProcessId, messageKey});
        return (DE)attachedEntity;
    }

    public DE correlateMessage(DE workflowAggregate, Object message, String correlationId) {
        return this.correlateMessage(workflowAggregate, message.getClass().getSimpleName(), correlationId);
    }

    public DE completeTask(DE workflowAggregate, String taskId) {
        Object attachedEntity = this.workflowAggregateRepository.save(workflowAggregate);
        this.client.newCompleteCommand(Long.parseLong(taskId, 16)).variables(workflowAggregate).send().join();
        logger.trace("Complete usertask '{}' for process '{}'", (Object)taskId, (Object)this.bpmnProcessId);
        return (DE)attachedEntity;
    }

    public DE completeUserTask(DE workflowAggregate, String taskId) {
        return this.completeTask(workflowAggregate, taskId);
    }

    public DE cancelTask(DE workflowAggregate, String taskId, String errorCode) {
        Object attachedEntity = this.workflowAggregateRepository.save(workflowAggregate);
        this.client.newThrowErrorCommand(Long.parseLong(taskId)).errorCode(errorCode).send().join();
        logger.trace("Complete usertask '{}' for process '{}'", (Object)taskId, (Object)this.bpmnProcessId);
        return (DE)attachedEntity;
    }

    public DE cancelUserTask(DE workflowAggregate, String taskId, String errorCode) {
        return this.cancelTask(workflowAggregate, taskId, errorCode);
    }
}

